% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ezsummary_categorical.r
\name{ezsummary_categorical}
\alias{ezsummary_c}
\alias{ezsummary_categorical}
\title{Easily summarize categorical data}
\usage{
ezsummary_categorical(tbl, n = FALSE, count = TRUE, p = TRUE,
  p_type = c("decimal", "percent"), digits = 3, rounding_type = c("round",
  "signif", "ceiling", "floor"), P = FALSE, round.N = 3,
  flavor = c("long", "wide"), fill = 0, unit_markup = NULL)

ezsummary_c(tbl, n = FALSE, count = TRUE, p = TRUE,
  p_type = c("decimal", "percent"), digits = 3, rounding_type = c("round",
  "signif", "ceiling", "floor"), P = FALSE, round.N = 3,
  flavor = c("long", "wide"), fill = 0, unit_markup = NULL)
}
\arguments{
\item{tbl}{A vector, a data.frame or a \code{dplyr} \code{tbl}.}

\item{n}{A T/F value; total counts of records. Default is
\code{FALSE}.}

\item{count}{A T/F value; count of records in each category.
Default is \code{TRUE}.}

\item{p}{A T/F value; proportion or percentage of records in each category.
Default is \code{TRUE}.}

\item{p_type}{A character string determining the output format of \code{p};
possible values are \code{decimal} and \code{percent}. Default value is
\code{decimal}.}

\item{digits}{A numeric value determining the rounding digits; Replacement
for \code{round.N}. Default setting is to read from \code{getOption()}.}

\item{rounding_type}{A character string determining the rounding method;
possible values are \code{round}, \code{signif}, \code{ceiling} and
\code{floor}. When \code{ceiling} or \code{floor} is selected, \code{digits}
won't have any effect.}

\item{P}{Deprecated; Will change the value of \code{p_type} if used in this
version.}

\item{round.N}{Deprecated; Will change the value of \code{rounding_type} if
used in this version.}

\item{flavor}{A character string with two possible inputs: "long" and "wide".
"Long" is the default setting which will put grouping information on the left
side of the table. It is more machine readable and is good to be passed into
the next analytical stage if needed. "Wide" is more print ready (except for
column names, which you can fix in the next step, or fix in LaTex or
packages like \code{htmlTable}). In the "wide" mode, the analyzed variable
will be the only "ID" variable and all the stats values will be presented
ogranized by the grouping variables (if any). If there is no grouping, the
outputs of "wide" and "long" will be the same.}

\item{fill}{If set, missing values created by the "wide" flavor will be
replaced with this value. Please check \code{\link[tidyr]{spread}} for
details. Default value is \code{0}}

\item{unit_markup}{When unit_markup is not NULL, it will call the ezmarkup
function and perform column combination here. To make everyone's life
easier, I'm using the term "unit" here. Each unit mean each group of
statistical summary results. If you want to know mean and stand deviation,
these two values are your units so you can put something like "[. (.)]" there
#' @param P Deprecated; Will change the value of \code{p_type} if used in this
version.}
}
\description{
\code{ezsummary_categorical()} summarizes categorical data.

Shorthand for ezsummary_categorical
}
\examples{
library(dplyr)
mtcars \%>\%
  group_by(am) \%>\%
  select(cyl, gear, carb) \%>\%
  ezsummary_categorical()

mtcars \%>\%
  select(cyl, gear, carb) \%>\%
  ezsummary_categorical(n=TRUE, round.N = 2)

}

