% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_sum.R
\name{sumgcols}
\alias{sumgcols}
\title{Sum groups of columns of a matrix and name the resulting columns}
\usage{
sumgcols(df, n, col_names = NULL)
}
\arguments{
\item{df}{A matrix with named rows and columns.}

\item{n}{Integer, specifying the size of each group.}

\item{col_names}{String vector of length n, with names to assign to the
resulting columns.}
}
\value{
A matrix where each column is the sum of groups of n
columns of the original matrix.
}
\description{
Groups a matrix by columns, by summing blocks of columns of size n each.
Matrix columns should be multiple of n.
}
\examples{
wio <- make_wio("wiodtest", quiet = TRUE)
sumgcols(wio$Yfd, wio$dims$FD, wio$names$g_names)
}
