% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{pparetoCP}
\alias{pparetoCP}
\alias{qparetoCP}
\alias{rparetoCP}
\title{Pareto change point distribution}
\usage{
pparetoCP(x, a0 = 1, a1 = 2, x0 = 1, x1 = 6)

qparetoCP(p, a0 = 1, a1 = 2, x0 = 1, x1 = 6)

rparetoCP(n, a0 = 1, a1 = 2, x0 = 1, x1 = 6)
}
\arguments{
\item{x}{a vector of quantiles.}

\item{a0}{a vector of shape parameter of the Pareto distribution before \eqn{x1}.}

\item{a1}{a vector of shape parameter of the Pareto distribution after \eqn{x1}.}

\item{x0}{a vector of scale parameter of the function.}

\item{x1}{a vector of change point value.}

\item{p}{a vector of probabilities.}

\item{n}{a number of observations. If length(n) > 1, the length is taken to be the number required.}
}
\value{
pparetoCP gives the distribution function, qparetoCP gives the quantile function, and rparetoCP generates random deviates.

The length of the result is determined by n for rparetoCP, and is the maximum of the lengths of the numerical arguments for the other functions.

The numerical arguments other than n are recycled to the length of the result. Only the first elements of the logical arguments are used.
}
\description{
Distribution function, quantile function and random generation for the Pareto change point distribution with \eqn{a0} equal to the shape of the first pareto distribution, \eqn{a1} equal to the shape of the second pareto distribution, \eqn{x0} equal to the scale and \eqn{x1} equal to the change point.
}
\details{
If not specified, \eqn{a0, a1, x0} and \eqn{x1} are taking respectively the values \eqn{1, 2, 1} and \eqn{6}

The cumulative Pareto change point distribution is given by :
  \deqn{
    F(x) = (x <= x1)* (1 - x^{-a0}) + (x > x1) * ( 1 - x^{-a1} * x1^{-a0 + a1})
  }
}
\examples{
par(mfrow = c(2,1))

plot(function(x) pparetoCP(x), 0, 5,ylab="distribution function",
     main = " Pareto change point Cumulative ")
mtext("pparetoCP(x)", adj = 0)

plot(function(x) qparetoCP(x), 0, 1,ylab="quantiles",
     main = " Pareto change point Quantile")
mtext("qparetoCP(x)", adj = 0)

#generate a sample of pareto distribution of size n
n <- 100
x <- rparetoCP(n)

}
