test_that("res_pois", {
  expect_identical(res_pois(integer(0), integer(0)), numeric(0))
  expect_identical(res_pois(1, 1), 0)
  expect_equal(res_pois(0, 1), -1.4142135623731)
  expect_identical(res_pois(NA, 1), NA_real_)
  expect_identical(res_pois(1, NA), NA_real_)
  expect_error(res_pois(1, 3, type = "unknown"))
  expect_equal(res_pois(1, 3, type = "raw"), -2)
  expect_equal(res_pois(1, 3), dev_pois(1, 3, res = TRUE))
  expect_equal(res_pois(c(1,3.5,4), 3, type = "raw"),
               c(-2, 0.5, 1))
  set.seed(101)
  expect_equal(res_pois(1:2, 2, simulate = TRUE, type = "raw"), c(-1L, -2L))
  expect_equal(res_pois(1:2, 2, simulate = TRUE), c(0.657868260861539, 0))
  set.seed(101)
  expect_equal(res_pois(1:2, 2, simulate = TRUE, type = "raw"), c(-1L, -2L))
  expect_equal(res_pois(1:2, 2, type = "data"), 1:2)
  set.seed(101)
  expect_equal(res_pois(1:2, 2, simulate = TRUE, type = "data"), c(1L, 0L))
})

test_that("res_pois_zi", {
  expect_identical(res_pois_zi(integer(0), integer(0)), numeric(0))
  expect_identical(res_pois_zi(1, 1), 0)
  expect_equal(res_pois_zi(0, 1), -1.4142135623731)
  expect_identical(res_pois_zi(NA, 1), NA_real_)
  expect_identical(res_pois_zi(1, NA), NA_real_)
  expect_error(res_pois_zi(1, 3, type = "unknown"))
  expect_equal(res_pois_zi(1, 3, type = "raw"), -2)
  expect_equal(res_pois_zi(1, 3), dev_pois(1, 3, res = TRUE))
  expect_equal(res_pois_zi(c(1,3.5,4), 3, type = "raw"),
               c(-2, 0.5, 1))
  set.seed(101)
  expect_equal(res_pois_zi(1:2, 2, simulate = TRUE, type = "raw"), c(-1L, -2L))
  expect_equal(res_pois_zi(1:2, 2, simulate = TRUE), c(0.657868260861539, 0))
  set.seed(101)
  expect_equal(res_pois_zi(1:2, 2, simulate = TRUE, type = "raw"), c(-1L, -2L))
  expect_equal(res_pois_zi(1:2, 2, type = "data"), 1:2)
  set.seed(101)
  expect_equal(res_pois_zi(1:2, 2, simulate = TRUE, type = "data"), c(1L, 0L))
  set.seed(101)
  expect_equal(res_pois_zi(1:10, 10, 0.5, simulate = TRUE, type = "data"),
               c(0L, 11L, 7L, 8L, 0L, 0L, 0L, 10L, 0L, 0L))
})

test_that("res_norm", {
  expect_identical(res_norm(integer(0), integer(0), integer(0)), numeric(0))
  expect_identical(res_norm(0), 0)
  expect_identical(res_norm(NA, 1, 1), NA_real_)
  expect_identical(res_norm(1, NA, 1), NA_real_)
  expect_identical(res_norm(1, 1, NA), NA_real_)
  expect_equal(res_norm(-2), dev_norm(-2, res = TRUE))
  expect_equal(res_norm(-2:2), -2:2)
  expect_equal(res_norm(-2:2, 3, 2), c(-2.5, -2, -1.5, -1, -0.5))
  expect_equal(res_norm(-2:2, type = "raw"), -2:2)
  expect_equal(res_norm(-2:2, mean = 2, type = "raw"), -4:0)
  expect_equal(res_norm(-2:2, mean = -2:2, type = "raw"), rep(0,5))
  set.seed(101)
  expect_equal(res_norm(1:2, 2, simulate = TRUE, type = "raw"), c(-0.326036490515386, 0.552461855419138))
  expect_equal(res_norm(1:2, 2, simulate = TRUE), c(-0.67494384395583, 0.214359459043425))
  set.seed(101)
  expect_equal(res_norm(1:2, 2, simulate = TRUE, type = "raw"), c(-0.326036490515386, 0.552461855419138))
  expect_equal(res_norm(1:2, 2, type = "data"), 1:2)
  set.seed(101)
  expect_equal(res_norm(1:2, 2, simulate = TRUE, type = "data"), c(1.67396350948461, 2.55246185541914))
})

test_that("res_lnorm", {
  expect_identical(res_lnorm(integer(0), integer(0), integer(0)), numeric(0))
  expect_identical(res_lnorm(exp(0)), 0)
  expect_identical(res_lnorm(1), 0)
  expect_identical(res_lnorm(0), -Inf)
  expect_identical(res_lnorm(-1), -Inf)
  expect_identical(res_lnorm(NA, 1, 1), NA_real_)
  expect_identical(res_lnorm(1, NA, 1), NA_real_)
  expect_identical(res_lnorm(1, 1, NA), NA_real_)
  expect_equal(res_lnorm(exp(-2:2)), -2:2)
  expect_equal(res_lnorm(exp(-2:2), meanlog = -1:3, sdlog = 1:5),
               c(-1, -0.5, -0.333333333333333, -0.25, -0.2))
  expect_equal(res_lnorm(1, type = "raw"), 0)
  expect_equal(res_lnorm(exp(1), type = "raw"), 1.71828182845905)
  set.seed(101)
  expect_equal(res_lnorm(1:2, 2, simulate = TRUE, type = "raw"), c(-2.05579169361621, 5.44961576366372))
  expect_equal(res_lnorm(1:2, 2, simulate = TRUE), c(-0.67494384395583, 0.214359459043425))
  set.seed(101)
  expect_equal(res_lnorm(1:2, 2, simulate = TRUE, type = "raw"), c(-2.05579169361621, 5.44961576366372))
  expect_equal(res_lnorm(1:2, 2, type = "data"), 1:2)
  set.seed(101)
  expect_equal(res_lnorm(1:2, 2, simulate = TRUE, type = "data"), c(5.33326440531444, 12.8386718625944))
})

test_that("res_binom", {
  expect_identical(res_binom(integer(0), integer(0), integer(0)), numeric(0))
  expect_identical(res_binom(NA, 1, 1), NA_real_)
  expect_identical(res_binom(1, NA, 1), NA_real_)
  expect_identical(res_binom(1, 1, NA), NA_real_)
  expect_equal(res_binom(1, 3, 0.5), dev_binom(1, 3, 0.5, res = TRUE))
  expect_equal(res_binom(0, 1, 0.5), -1.17741002251547)
  expect_equal(res_binom(1, 1, 0.5), 1.17741002251547)
  expect_equal(res_binom(0, 1, 0.7), -1.55175565365552)
  expect_equal(res_binom(1, 1, 0.7), 0.844600430900592)
  expect_identical(res_binom(1, 2, 0.5), 0)
  expect_identical(res_binom(5, 10, 0.5), 0)
  expect_equal(res_binom(1, 10, 0.5), -3.25271578350125)
  expect_equal(res_binom(1:9, 10, 0.5),
               c(-3.25271578350125, -2.74227242773795, -2.17039427586256, -1.47914119729235,
                 0, 1.47914119729235, 2.17039427586256, 2.74227242773795, 3.25271578350125
               ))
  expect_equal(res_binom(0, 2, 0.5, type = "raw"), -1)
  set.seed(101)
  expect_equal(res_binom(1:2, simulate = TRUE, type = "raw"), c(-0.5, -0.5))
  expect_equal(res_binom(1:2, 2, simulate = TRUE), c(0, 0))
  set.seed(101)
  expect_equal(res_binom(1:2, simulate = TRUE, type = "raw"), c(-0.5, -0.5))
  expect_equal(res_binom(1:2, 2, type = "data"), 1:2)
  set.seed(101)
  expect_equal(res_binom(1:2, 2, simulate = TRUE, type = "data"), 1:0)
})

test_that("res_bern", {
  expect_identical(res_bern(logical(0), integer(0)), numeric(0))
  expect_identical(res_bern(NA, 1), NA_real_)
  expect_identical(res_bern(1, NA), NA_real_)
  expect_identical(res_bern(1, 1), 0)
  expect_identical(res_bern(0, 0), 0)
  expect_identical(res_bern(1, 0), Inf)
  expect_identical(res_bern(0, 1), -Inf)
  expect_equal(res_bern(0, 0.5), dev_bern(0, 0.5, res = TRUE))
  expect_identical(res_bern(0, 1), -Inf)
  expect_identical(res_bern(c(1, 1, 0, 0), c(0, 1, 0, 1)),
                   c(Inf, 0, 0, -Inf))
  expect_equal(res_bern(c(1,0), 0.5),
               c(1.17741002251547, -1.17741002251547))
  expect_equal(res_bern(c(1,0), 0.7),
               c(0.844600430900592, -1.55175565365552))
  expect_equal(res_bern(c(1,0), c(0.7, 0.5)),
               c(0.844600430900592,  -1.17741002251547))
  expect_equal(res_bern(c(0,1), c(1, 0), type = "raw"), c(-1, 1))
  set.seed(101)
  expect_equal(res_bern(1:2, simulate = TRUE, type = "raw"), c(-0.5, -0.5))
  expect_equal(res_bern(1:2, simulate = TRUE), c(1.17741002251547, 1.17741002251547))
  set.seed(101)
  expect_equal(res_bern(1:2, simulate = TRUE, type = "raw"), c(-0.5, -0.5))
  expect_equal(res_bern(1:2, type = "data"), 1:2)
  set.seed(101)
  expect_equal(res_bern(0:1, simulate = TRUE, type = "data"), c(0L, 0L))
})

test_that("res_gamma_pois", {
  expect_identical(res_gamma_pois(integer(0), integer(0), integer(0)), numeric(0))
  expect_identical(res_gamma_pois(1, 1, 0), 0)
  expect_equal(res_gamma_pois(0, 1, 0), -1.4142135623731)
  expect_identical(res_gamma_pois(1, 1, 1), 0)
  expect_identical(res_gamma_pois(NA, 1, 1), NA_real_)
  expect_identical(res_gamma_pois(1, NA, 1), NA_real_)
  expect_identical(res_gamma_pois(1, 1, NA), NA_real_)
  expect_error(res_gamma_pois(1, 3, 1, type = "unknown"))
  expect_equal(res_gamma_pois(1, 3, 1, type = "raw"), -2)
  expect_equal(res_gamma_pois(1, 3, 2), dev_gamma_pois(1, 3, 2, res = TRUE))
  expect_equal(res_gamma_pois(c(1,3.5,4), 3, 10, type = "raw"),
               c(-2, 0.5, 1))
  set.seed(101)
  expect_identical(res_gamma_pois(1:2, 2, 2, simulate = TRUE, type = "raw"), c(-1, 2))
  expect_equal(res_gamma_pois(1:2, 2, 2, simulate = TRUE), c(0.699911676381084, -0.382338214383655))
  set.seed(101)
  expect_identical(res_gamma_pois(1:2, 2, 2, simulate = TRUE, type = "raw"), c(-1, 2))
  expect_equal(res_gamma_pois(1:2, 2, type = "data"), 1:2)
  set.seed(101)
  expect_equal(res_gamma_pois(1:2, 2, simulate = TRUE, type = "data"), 2:1)
})

test_that("res_neg_binom", {
  expect_identical(res_neg_binom(integer(0), integer(0), integer(0)), numeric(0))
  expect_identical(res_neg_binom(1, 1, 0), 0)
  expect_equal(res_neg_binom(0, 1, 0), -1.4142135623731)
  expect_identical(res_neg_binom(1, 1, 1), 0)
  expect_identical(res_neg_binom(NA, 1, 1), NA_real_)
  expect_identical(res_neg_binom(1, NA, 1), NA_real_)
  expect_identical(res_neg_binom(1, 1, NA), NA_real_)
  expect_error(res_neg_binom(1, 3, 1, type = "unknown"))
  expect_equal(res_neg_binom(1, 3, 1, type = "raw"), -2)
  expect_equal(res_neg_binom(1, 3, 2), dev_gamma_pois(1, 3, 2, res = TRUE))
  expect_equal(res_neg_binom(c(1,3.5,4), 3, 10, type = "raw"),
               c(-2, 0.5, 1))
  set.seed(101)
  expect_identical(res_neg_binom(1:2, 2, 2, simulate = TRUE, type = "raw"), c(-1, 2))
  expect_equal(res_neg_binom(1:2, 2, 2, simulate = TRUE), c(0.699911676381084, -0.382338214383655))
  set.seed(101)
  expect_identical(res_neg_binom(1:2, 2, 2, simulate = TRUE, type = "raw"), c(-1, 2))
  expect_equal(res_neg_binom(1:2, 2, type = "data"), 1:2)
  set.seed(101)
  expect_equal(res_neg_binom(1:2, 2, simulate = TRUE, type = "data"), 2:1)
})
