% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non-standard-beta-distribution.R
\name{NSBeta}
\alias{NSBeta}
\alias{dnsbeta}
\alias{pnsbeta}
\alias{qnsbeta}
\alias{rnsbeta}
\title{Non-standard beta distribution}
\usage{
dnsbeta(x, shape1, shape2, min = 0, max = 1, log = FALSE)

pnsbeta(q, shape1, shape2, min = 0, max = 1, lower.tail = TRUE,
  log.p = FALSE)

qnsbeta(p, shape1, shape2, min = 0, max = 1, lower.tail = TRUE,
  log.p = FALSE)

rnsbeta(n, shape1, shape2, min = 0, max = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{shape1, shape2}{non-negative parameters of the Beta distribution.}

\item{min, max}{lower and upper bounds.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \leq x]},
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Non-standard form of beta distribution with lower and upper bounds
denoted as \code{min} and \code{max}. By default \code{min=0}
and \code{max=1} what leads to standard beta distribution.
}
\examples{

x <- rnsbeta(1e5, 5, 13, -4, 8)
hist(x, 100, freq = FALSE)
curve(dnsbeta(x, 5, 13, -4, 8), -4, 6, col = "red", add = TRUE) 
hist(pnsbeta(x, 5, 13, -4, 8))
plot(ecdf(x))
curve(pnsbeta(x, 5, 13, -4, 8), -4, 6, col = "red", lwd = 2, add = TRUE)

}
\seealso{
\code{\link[stats]{Beta}}
}
\concept{
Univariate

Continuous
}
\keyword{distribution}
