% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile_results.R
\name{compile_results}
\alias{compile_results}
\title{Compile resulting analyses}
\usage{
compile_results(
  expstudy,
  ...,
  output = c("metrics", "proportions"),
  output_args = list(metrics = NULL, proportions = NULL),
  output_format = c("unformatted", "formatted")
)
}
\arguments{
\item{expstudy}{an \code{\link[=expstudy]{expstudy()}}}

\item{...}{variables to generate grouped analyses. All combinations of variables
provided will be generated and used as groups in results.}

\item{output}{type of result to output (i.e., with metrics or proportions). If omitted,
both will be generated and returned in a list.}

\item{output_args}{additional arguments to pass to \code{\link[=add_metrics]{add_metrics()}} and \code{\link[=add_proportions]{add_proportions()}}. If
omitted, default parameters will be used for both functions.}

\item{output_format}{resulting output format. If omitted, both will be generated and returned as
a list.}
}
\value{
a (potentially nested) list with resulting analysis according to arguments
passed to the function.
}
\description{
For a streamlined approach, this function combines multiple other
\link{expstudy-package} functions to generate multiple analyses simultaneously.
All grouping combinations will be generated from variables passed as
<\code{\link[rlang:dyn-dots]{dynamic-dots}}>, then analytics will be created for each.

Resulting output can have the typical metrics via \code{\link[=add_metrics]{add_metrics()}}, or
proportions via \code{\link[=add_proportions]{add_proportions()}}. Default parameters are used for each
function, however, you can pass additional parameters in a list to the
corresponding function element via the \code{output_args} argument.

Furthermore, you can choose to have the results return unformatted (for
further calculations or analysis) or formatted (for presentation purposes).

This function was meant to provide quick results for routine analysis. Any
additional in-depth analyses should make use of individual \code{expstudy}
functions instead.
}
\examples{
  es <- expstudy(
    data = mortexp,
    actuals = ACTUAL_DEATHS,
    expecteds = EXPECTED_DEATHS,
    exposures =  EXPOSURE,
    variances = VARIANCE_DEATHS
  )

  # Quickly generate multiple analyses by simply declaring variables of
  # interest within an experience study.
  es \%>\%
    compile_results(
      GENDER,
      SMOKING_STATUS,
      UNDERWRITING_CLASS
    )

}
\seealso{
\code{\link[=aggregate]{aggregate()}} \code{\link[=add_metrics]{add_metrics()}} \code{\link[=add_credibility]{add_credibility()}} \code{\link[=add_proportions]{add_proportions()}}
\code{\link[=format_metrics]{format_metrics()}}
}
