% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9-deprecated.R
\docType{methods}
\name{modSwap}
\alias{modSwap}
\alias{modSwap,ExprsBinary-method}
\title{Swap Case Subjects}
\usage{
modSwap(object, how = "fp", percent = 10, theta = 1)

\S4method{modSwap}{ExprsBinary}(object, how = "fp", percent = 10,
  theta = 1)
}
\arguments{
\item{object}{An \code{ExprsBinary} object to mutate.}

\item{how}{A character string. The method used to mutate case subjects. Select from
"rp.1", "rp.2", "fp", "ng", or "tg". Alternatively, another \code{ExprsBinary}
object. See Details.}

\item{percent}{A numeric scalar. The percentage of subjects to mutate.}

\item{theta}{A numeric scalar. Applies a weight to the distribution of means when
mutating subjects via the "ng" or "tg" method.}
}
\value{
An \code{ExprsBinary} object containing mutated subjects with an index
 appended to the \code{$mutated} column of the \code{@annot} slot.
}
\description{
This experimental function mutates a percentage of case subjects
 into noisy positives, false positives, or defined out-groups.
}
\details{
This function includes several methods for distorting the features of \code{ExprsBinary}
 subjects. The "rp.1" method randomizes subject vectors to create "subject noise".
 The "rp.2" method creates a new subject vector by randomly sampling feature values
 from the respective feature vector. The "fp" method creates a new subject vector
 by randomly sampling feature values from the respective control feature vector.

The "ng" and "tg" methods create out-groups by defining new means for each feature.
 These methods yield fixed distributions around new feature means such that
 the mean of all new feature means remains constant. The argument \code{theta}
 dictates how much the new feature mean might differ from the original feature mean
 (where larger \code{theta} values lead to more similar new feature means). For
 the "ng" method, the mean of new feature means equals that of the original features
 for case subjects only. On the other hand, for the "tg" method, the mean of new
 feature means equals that of the original features for all subjects.

Alternatively, by providing another \code{ExprsBinary} object as the \code{how}
 argument, this function will swap a percentage of case subjects from the main dataset
 with control subjects from the second dataset.
}
\section{Methods (by class)}{
\itemize{
\item \code{ExprsBinary}: A method to mutate \code{ExprsBinary} objects.
}}

