\name{SpatialPointsBreeding}
\alias{SpatialPointsBreeding}
\alias{SpatialPointsBreeding-class}
\alias{SpatialPointsBreeding,SpatialPolygons-method}
\alias{SpatialPointsBreeding,missing-method}
\alias{SpatialPointsBreeding,integer-method}

\alias{plot,SpatialPointsBreeding,missing-method}
\alias{plot,SpatialPointsBreeding,eppMatrix-method}
\alias{plot.SpatialPointsBreeding}

\title{Converts a \code{data.frame} to an object of class \code{SpatialPointsBreeding} }

\description{
Converts a \code{\link{data.frame}} to a \code{SpatialPointsBreeding} object.
The \code{SpatialPointsBreeding} class extends \code{\link[sp]{SpatialPointsDataFrame}} 
with three extra slots defining the id (i.e. nest or breeding box) and the pair identity
(i.e. male and female), respectively.
}

\usage{
SpatialPointsBreeding(data, proj4string, coords = ~x + y, breeding = ~male + female, id)
  
\S4method{plot}{SpatialPointsBreeding,missing}(x, pch = 20, axes = FALSE, add = FALSE, 
                  xlim = NULL, ylim = NULL, ..., cex = 1, col = "grey", 
                  lwd = 1, bg = "grey90")  

\S4method{plot}{SpatialPointsBreeding,eppMatrix}(x, y, pch = 20, axes = FALSE, add = FALSE, 
                   xlim = NULL, ylim = NULL, ..., cex = 1, col = "grey", 
                   col.epp = "red", 
                   lwd = 1, lty = 2, bg = "grey90")  


}

\arguments{
  \item{data}{
    a \code{\link{data.frame}}  containing the coordinates (e.g. "x", "y"), the location id, 
    and the pair identity (e.g. "male", "female") together with any other optional variables
    (e.g. individuals or nest traits).
}

  \item{proj4string}{
    A \code{\link[sp]{CRS}} object containing a valid proj4 string. 
    See \code{\link[sp]{CRS}} \code{\link[sp]{proj4string}} for details.
}

  \item{coords}{
   Formula specifying which columns in object are the spatial coordinates.
   Argument passed to \code{\link[sp]{coordinates}}
}

  \item{id}{
  Integer specifying the location id (e.g. nest box number, den ID).
}
  \item{breeding}{
  Formula defining the male and female ID in that order (in the form of e.g. \code{~male+female}).
}

  \item{x}{a \code{SpatialPointsBreeding} object}
  \item{y}{an \code{eppMatrix} object}
  \item{pch}{see  \code{plot.default} }
  \item{axes}{see \code{plot.default} }
  \item{add}{see \code{plot.default} }
  \item{xlim}{see \code{plot.default} }
  \item{ylim}{see \code{plot.default} }
  \item{...}{further arguments to pass to plot(as(x, "Spatial")}
  \item{cex}{see \code{plot.default} }
  \item{col}{see \code{plot.default} }
  \item{col.epp}{extra-pair partners color}  
  \item{lwd}{see \code{plot.default} }
  \item{lty}{see \code{plot.default} }
  \item{bg}{see \code{plot.default} }

}

\value{
Item of the class 'SpatialPointsBreeding' with 8 slots.

  \item{id }{Location ID (see input)}
  \item{male }{ (Male IDs.)}
  \item{female }{Female IDs.}
  \item{data }{A \code{data.frame} containing all the optional variables (except location and individual ID-s)}
  \item{coords.nrs}{see \code{\link[sp]{SpatialPoints}} }
  \item{coords }{coordinates}
  \item{bbox }{see \code{\link[sp]{Spatial}} }
  \item{proj4string}{see \code{\link[sp]{CRS}} }
}


\seealso{\code{\link[expp]{epp}}}


\examples{
d = data.frame(
  x = c(4, 17, 16, 41, 41, 43, 86, 62, 71, 92, 95,53, 34, 27, 53), 
  y = c(3, 18, 36, 6, 18, 50, 3, 21, 40, 43, 57, 62, 62, 45, 37), 
  id = 1:15,male = paste0('m', 1:15), female = paste0('f', 1:15), 
    stringsAsFactors = FALSE)

b = SpatialPointsBreeding(d, id = 'id', breeding = ~ male+female)	

plot(b)


} 
  

\keyword{ spatial }







