% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore.R
\name{explain_tree}
\alias{explain_tree}
\title{Explain a target using a simple decision tree (classification or regression)}
\usage{
explain_tree(data, target, maxdepth = 3, minsplit = 20, cp = 0,
  size = 0.7, ...)
}
\arguments{
\item{data}{A dataset}

\item{target}{Target variable}

\item{maxdepth}{Maximal depth of the tree}

\item{minsplit}{The minimum number of observations that must exist in a node in order for a split to be attempted}

\item{cp}{Complexity parameter}

\item{size}{Textsize of plot}

\item{...}{Further arguments}
}
\value{
Plot
}
\description{
Explain a target using a simple decision tree (classification or regression)
}
\examples{
data <- iris
data$is_versicolor <- ifelse(iris$Species == "versicolor", 1, 0)
data$Species <- NULL
explain_tree(data, target = is_versicolor)
}
