% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exdqlmForecast.R
\name{exdqlmForecast}
\alias{exdqlmForecast}
\title{k-step-ahead Forecast}
\usage{
exdqlmForecast(
  y,
  start.t,
  k,
  m1,
  fFF = NULL,
  fGG = NULL,
  plot = TRUE,
  add = FALSE,
  cols = c("purple", "magenta")
)
}
\arguments{
\item{y}{A univariate time-series.}

\item{start.t}{Time index at which to start the forecast.}

\item{k}{Number of k-steps-ahead to forecast.}

\item{m1}{An object of class "\code{exdqlm}".}

\item{fFF}{State vector for the forecast steps. \code{fFF} must have either 1 (non-time-varying) or k (time-varying) columns. The dimension of \code{fFF} must match the estimated exdqlm in \code{m1}.}

\item{fGG}{Evolution matrix for the forecast steps. \code{fGG} must be either a matrix (non-time-varying) or an array of depth k (time-varying). The dimensions of \code{fGG} must match the estimated exdqlm in \code{m1}.}

\item{plot}{If \code{TRUE} the forecasted quantile estimates and 95\% credible intervals are plotted, along with the filtered quantile estimates and 95\% credible intervals for reference. Default is \code{TRUE}.}

\item{add}{If \code{TRUE}, the forecasted quantile will be added to the existing plot. Default is \code{FALSE}.}

\item{cols}{Two colors used to plot filtered and forecasted quantile estimates respectively. Default is \code{c("purple","magenta")}.}
}
\value{
A list containing the following is returned:
\itemize{
\item \code{fa} - The forecasted state mean vectors.
\item \code{fR} - The forecasted state covariance matrices.
\item \code{ff} - The forecasted quantile mean estimates.
\item \code{fQ} - The forecasted quantile variances.
}
}
\description{
The function estimates and plots the k-step-ahead forecasted quantile distribution from the filtered quantile estimates.
}
\examples{
\donttest{
y = scIVTmag[1:100]
model = polytrendMod(1,quantile(y,0.85),10)
M0 = exdqlmISVB(y,p0=0.85,model,df=c(0.98),dim.df = c(1),
                   gam.init=-3.5,sig.init=15)
exdqlmForecast(y,start.t=90,k=10,M0)
}

}
