% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jexcel.R
\name{excelTable}
\alias{excelTable}
\title{Create excel table using jexcel library}
\usage{
excelTable(data = NULL, columns = NULL, colHeaders = NULL,
  rowHeight = NULL, nestedHeaders = NULL, defaultColWidth = NULL,
  minDimensions = NULL, columnSorting = TRUE, columnDrag = FALSE,
  columnResize = TRUE, rowResize = FALSE, rowDrag = TRUE,
  editable = TRUE, allowInsertRow = TRUE, allowInsertColumn = TRUE,
  allowDeleteRow = TRUE, allowDeleteColumn = TRUE,
  allowRenameColumn = TRUE, allowComments = FALSE, wordWrap = FALSE,
  selectionCopy = TRUE, mergeCells = NULL, search = FALSE,
  pagination = NULL, fullscreen = FALSE, lazyLoading = FALSE,
  loadingSpin = FALSE, style = NULL)
}
\arguments{
\item{data}{a data object, can either be dataframe or a matrix.}

\item{columns}{a dataframe containing different column attributes.
The row number  of the dataframe specifies the column for which the attribute is to be specified and
the header of the dataframe specifies the attribute.The following attributes are supported:
 \itemize{
  \item \strong{title:} a string specifying title of the column or the column header.
  \item \strong{width:} a numerical value specifying the width of the column.
  \item \strong{type:} the type of the column. It can be one of text, numeric, hidden, dropdown,
  autocomplete, checkbox, radio, calendar, image or color.
  \item \strong{source:} a vector of options for column when the type is 'dropdwown'.
   \item \strong{multiple:} a boolean value indicating if the multiple options can be selected when the type is 'dropdown'.
   The default value is false.
   \item \strong{render:} a character value indicating if we want to render color for 'color' type instead of text. If render
   is provided a value 'square', color is rendered instead of text.
}}

\item{colHeaders}{a vector of specifying the column headers. If both 'colHeaders' and 'title' attribute
in columns is specified, the latter will take precedence.}

\item{rowHeight}{a dataframe or matrix specifying height of different rows. The first column consists of numerical value that
specifies the row number and the second column is also numerical value that specifies the height in pixels.}

\item{nestedHeaders}{a list of dataframe having title and colspan as the attributes. The nested header
in the same level should be in the same dataframe.}

\item{defaultColWidth}{a numeric value specifying the default width of column when the width attribute of column is not specified.
The default value is 50.}

\item{minDimensions}{a vector that defines the minimum number of rows and columns in the tables irrespective of the size of data.
The first parameter should be of number of columns followed by number of rows. If data is null then it will create an empty table
with the given dimensions.}

\item{columnSorting}{a boolean value indicating if column sorting should be enabled. When enabled double click
on the table headers sorts the column. By default it is set to true.}

\item{columnDrag}{a boolean value indicating if column dragging is enabled. By default it is set to false.}

\item{columnResize}{a boolean value indicating if column resizing is enabled. By default it is set to true.}

\item{rowResize}{a boolean value indicating if row resizing is enabled. By default it is set to false.}

\item{rowDrag}{a boolean value indicating if rowDragging is enabled or not. By default it is set to true.}

\item{editable}{a boolean value indicating if the table can be edited. By default it is set to true}

\item{allowInsertRow}{a boolean value indicating if user is allowed to insert new rows. By default it is set to true.}

\item{allowInsertColumn}{a boolean value indicating if user is allowed to insert a new column. By default it is set to true.}

\item{allowDeleteRow}{a boolean value indicating if user is allowed to delete a row. By default it is set to true.}

\item{allowDeleteColumn}{a boolean value indicating if user is allowed to delete a column. By default it is set to true.}

\item{allowRenameColumn}{a boolean value indicating if user is allowed to rename the columns. By default it is set to true}

\item{allowComments}{a boolean value indicating if commenting on cell should be enabled. By default it is set to false.}

\item{wordWrap}{a boolean value indicating if words in the cells should wrap. By default it is set to false.}

\item{selectionCopy}{a boolean value indicating if user is allowed to copy selected cells. By default it is set to true.}

\item{mergeCells}{a list containing vector of colspan and rowspan respectively such that the tag  of the list specifies the
cell number.}

\item{search}{a boolean value indicating if search should be enabled. By default it is set to false.}

\item{pagination}{a numeric value indicating number of rows in a single page. If the data does not fit in a
single page pagination is enabled.}

\item{fullscreen}{a boolean value indicating if the table should be fullscreen. By default it is set to false.}

\item{lazyLoading}{a boolean value indicating if lazy loading should be enabled. By default it is set to false.}

\item{loadingSpin}{a boolean value indicating if loading spinner should be enabled. By default it is set to false.}

\item{style}{a named list to specify style for each cell. The name should be the cell address and the value should be
a valid 'css' string with styles.  For example, to style cell 'A1', the list should look like
\code{style = list("A1" = "background-color: gray;")}.}
}
\description{
This function is used to create excel like table
}
\examples{
### table example ---
library(excelR)

data = data.frame(Model = c('Mazda', 'Pegeout', 'Honda Fit', 'Honda CRV'),
                  Date=c('2006-01-01', '2005-01-01','2004-01-01', '2003-01-01' ),
                  Availability = c(TRUE, FALSE, TRUE, TRUE))


columns = data.frame(title=c('Model', 'Date', 'Availability'),
                     width= c(300, 300, 300),
                     type=c('text', 'calendar', 'checkbox'))

excelTable(data=data, columns = columns)

### no arguments with matrix ----
excelTable(matrix(1:20, ncol=4))

### some additional arguments with mtcars ----
library(excelR)

# for now we need to manipulate a data.frame with rownames
mtcars2 <- cbind(name = rownames(mtcars), mtcars, stringsAsFactors = FALSE)
mtcars2$name <- rownames(mtcars)
# change rownames so jsonlite will not convert to a column
rownames(mtcars2) <- seq_len(nrow(mtcars2))

excelTable(
  data = mtcars2,
  colHeaders = toupper(colnames(mtcars2)), # upper case the column names
  fullscreen = TRUE,  # fill screen with table
  columnDrag = TRUE,  # allow dragging (reordering) of columns
  rowDrag = FALSE, # disallow dragging (reordering) of rows
  wordWrap = TRUE, # wrap text in a cell if is longer than cell width
)

# an empty table
excelTable(
  data = NULL,
  minDimensions = c(5,20) # columns, rows
)


### styling cells ----
library(excelR)

excelTable(
  data = matrix(1:100, ncol = 10),
  style = list(
    "A1" = 'background-color: orange; fontWeight: bold; color: white;',
    "B1" = 'background-color: orange;',
    "C1" = 'background-color: orange;',
    "D1" = 'background-color: orange;'
  )
)
}
