% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extremes.R
\name{pminimum}
\alias{pminimum}
\alias{polynomial_minimum}
\title{Polynomial Minimum}
\usage{
pminimum(
  p,
  interval,
  lower = min(interval),
  upper = max(interval),
  tol = 1e-09
)

polynomial_minimum(
  p,
  interval,
  lower = min(interval),
  upper = max(interval),
  tol = 1e-09
)
}
\arguments{
\item{p}{polynomial}

\item{interval}{numeric:    a vector containing the end-points of the interval to be searched for the minimum}

\item{lower}{numeric: the lower end point of the interval to be searched (default: \code{min(interval)})}

\item{upper}{numeric: the upper end point of the interval to be searched (default: \code{max(interval)})}

\item{tol}{numeric: the desired accuracy (default: \code{1e-9})}
}
\value{
The minimal function value.
}
\description{
Computes the minimum of a polynomial in the interval \eqn{[lower, upper]}. The values and the interval borders of the
polynomial \code{p} are evaluated and the minimum value is returned.
}
\examples{
p <- polynomial(c(-5, 3, -3, 1))
pminimum(p, -3, 3)
}
