% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histbreaks.R
\name{histbreaks}
\alias{histbreaks}
\alias{rand_breaks}
\alias{dhistbreaks}
\title{Histogram Breakpoints}
\usage{
histbreaks(breaks, size, outer = TRUE, ...)

rand_breaks(breaks, size, outer = TRUE, ...)

dhistbreaks(breaks, size, outer = TRUE, ...)
}
\arguments{
\item{breaks}{numeric: a vector of possible break points}

\item{size}{integer: number of break points}

\item{outer}{logical: should be the first and last element of the included breaks (default: \code{TRUE})}

\item{...}{further parameters given if sampling of \code{size} is necessary, see \link[base:sample]{base::sample}}
}
\value{
A vector of breakpoints.
}
\description{
Randomly selects \code{size} breakpoints from \code{breaks}. If \code{outer} is \code{TRUE}, then
the first and last element of \code{breaks} is always included into the returned break points.
If \code{size} is a vector, the number of breakpoints is first sampled from \code{size}.
}
\examples{
# Always includes 100 and 200
histbreaks(seq(100, 200, by=10), 4)
# Always includes 100 and 200 and chooses randomly between 3 to 5 break points  
histbreaks(seq(100, 200, by=10), 3:5)           
# May not include 100 and 200
histbreaks(seq(100, 200, by=10), 4, outer=FALSE) 
}
