% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_data.R
\name{cor_data}
\alias{cor_data}
\alias{dcorr}
\title{Correlation and Data Generation}
\usage{
cor_data(
  x,
  y,
  r,
  method = c("pearson", "kendall", "spearman"),
  ...,
  maxit = 1000
)

dcorr(x, y, r, method = c("pearson", "kendall", "spearman"), ..., maxit = 1000)
}
\arguments{
\item{x}{numeric: given \code{x} values}

\item{y}{numeric: given \code{y} values}

\item{r}{numeric: desired correlation}

\item{method}{character: indicates which correlation coefficient is to be computed (default: `"pearson")}

\item{...}{further parameters given to \code{\link[stats:cor]{stats::cor()}}}

\item{maxit}{numeric: maximal number of iterations (default: \code{1000})}
}
\value{
A matrix with two columns and an attribute \code{interim} for intermediate values as matrix.
The rows of the matrix contain:
\itemize{
\item if \code{method=="pearson"}: \eqn{x_i}, \eqn{y_i},  \eqn{x_i-bar{x}}, \eqn{y_i-\bar{y}},
\eqn{(x_i-bar{x})^2}, \eqn{(y_i-\bar{y})^2}, and \eqn{(x_i-bar{x})((y_i-\bar{y})}.
\item if \code{method=="kendall"}:
\itemize{
\item \eqn{x_i}: The original x values.
\item \eqn{y_i}: The original y values.
\item \eqn{p_i}: The number of concordant pairs.
\item \eqn{q_i}: The number of discordant pairs.
}
\item if \code{method=="spearman"}: \eqn{x_i}, \eqn{y_i}, \eqn{p_i} (concordant pairs), and \eqn{q_i} (disconcordant pairs).
In a final step a vector with the row \code{sums} is appended as further column.
}
}
\description{
Generates a data set based on \code{x} and \code{y} for a given target correlation \code{r} according to \code{\link[stats:cor]{stats::cor()}}.
The algorithm modifies the order of the \code{y}'s, therefore is guaranteed that the (marginal) distribution of \code{x}
and \code{y} will not be modified. Please note that it is not guaranteed that the final correlation will be the desired correlation;
the algorithm interactively modifies the order. If you are unsatisfied with the result, it might help to increase \code{maxit}.
}
\examples{
x <- runif(6)
y <- runif(6)
xy <- cor_data(x, y, r=0.6)
cbind(x, y, xy)
}
