% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08C_BNM_GA.R
\name{StrLearningGA_BNM}
\alias{StrLearningGA_BNM}
\title{Structure Learning for BNM by simple GA}
\usage{
StrLearningGA_BNM(
  U,
  Z = NULL,
  w = NULL,
  na = NULL,
  seed = 123,
  population = 20,
  Rs = 0.5,
  Rm = 0.005,
  maxParents = 2,
  maxGeneration = 100,
  successiveLimit = 5,
  crossover = 0,
  elitism = 0,
  filename = NULL,
  verbose = TRUE
)
}
\arguments{
\item{U}{U is either a data class of exametrika, or raw data. When raw data is given,
it is converted to the exametrika class with the \link{dataFormat} function.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{seed}{seed for random.}

\item{population}{Population size. The default is 20}

\item{Rs}{Survival Rate. The default is 0.5}

\item{Rm}{Mutation Rate. The default is 0.005}

\item{maxParents}{Maximum number of edges emanating from a single node. The default is 2.}

\item{maxGeneration}{Maximum number of generations.}

\item{successiveLimit}{Termination conditions. If the optimal individual does not change
for this number of generations, it is considered to have converged.}

\item{crossover}{Configure crossover using numerical values. Specify 0 for uniform
crossover, where bits are randomly copied from both parents. Choose 1 for single-point
crossover with one crossover point, and 2 for two-point crossover with two crossover points.
The default is 0.}

\item{elitism}{Number of elites that remain without crossover when transitioning to
the next generation.}

\item{filename}{Specify the filename when saving the generated adjacency matrix in CSV format.
The default is null, and no output is written to the file.}

\item{verbose}{verbose output Flag. default is TRUE}
}
\value{
\describe{
\item{adj}{Optimal adjacency matrix}
\item{testlength}{Length of the test. The number of items included in the test.}
\item{TestFitIndices}{Overall fit index for the test.See also \link{TestFit}}
\item{nobs}{Sample size. The number of rows in the dataset.}
\item{testlength}{Length of the test. The number of items included in the test.}
\item{crr}{correct response ratio}
\item{TestFitIndices}{Overall fit index for the test.See also \link{TestFit}}
\item{adj}{Adjacency matrix}
\item{param}{Learned Parameters}
\item{CCRR_table}{Correct Response Rate tables}
}
}
\description{
Generating a DAG from data using a genetic algorithm.
}
\details{
This function generates a DAG from data using a genetic algorithm.
Depending on the size of the data and the settings, the computation may
take a significant amount of computational time. For details on the
settings or algorithm, see Shojima(2022), section 8.5
}
\examples{
\donttest{
# Perform Structure Learning for Bayesian Network Model using Genetic Algorithm
# Parameters are set for balanced exploration and computational efficiency
StrLearningGA_BNM(J5S10,
  population = 20, # Size of population in each generation
  Rs = 0.5, # 50\% survival rate for next generation
  Rm = 0.002, # 0.2\% mutation rate for genetic diversity
  maxParents = 2, # Maximum of 2 parent nodes per item
  maxGeneration = 100, # Maximum number of evolutionary steps
  crossover = 2, # Use two-point crossover method
  elitism = 2 # Keep 2 best solutions in each generation
)
}
}
