% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{main.function}
\alias{main.function}
\title{Provide sample size solutions for target size and power.}
\usage{
main.function(
  alpha,
  delta,
  beta = 0.75,
  p0 = 0.5,
  type = 2,
  plt = FALSE,
  out = (-1),
  b.lim = 5,
  prin = FALSE
)
}
\arguments{
\item{alpha}{value of nominal size of test}

\item{delta}{value of clinically relevant difference}

\item{beta}{scalar target for power}

\item{p0}{single value or range of values for baseline probability}

\item{type}{type of maximisation (see n1.get documentation)}

\item{plt}{Plot n1 solutions versis n0 if true}

\item{out}{More solutions output if out > 0 than out < 0 (see details)}

\item{b.lim}{maximum imbalance of sample sizes}

\item{prin}{shows progress of calculation}
}
\value{
list with elements n0 and n1
}
\description{
Function gives smallest values for n1 as function of n0 that achieve target
size and power.
}
\details{
If out > 0 all solutions (including n1=Inf) are return. If out=0, infinite
values are suppressed. If out < 0, only output satisfying the balance
criterin are output.
}
\note{
The appropriate data file needs to have been downloaded corresponding
to the desired value of alpha and delta. This can be done with the
fetch.data() function.
}
\examples{

# To run this function you need to have downloaded LIB.a025.d20
# into the global environment. We are interested in designs with
# exact size 0.025 and power at least 0.75 when delta=0.20. The
# baseline probability is thought to be between 0.3 and 0.5.
rdata_file = system.file('files', 'LIB.a025.d20.Rdata', package = 'exact.n')
load(rdata_file)
#' main.function(.025,0.20,p0=c(0.3,0.5),beta=0.75,plt=TRUE)
# The value of the function is the minimum value of n1 for a range
# of values of n0. The sample size ratio is limited to 5 by default.

}
\references{
C.J. Lloyd & R. Ripamonti (2021) A comprehensive open-source
library for exact required sample size in binary clinical trials.
Contemporary Clinical Trials 107. \doi{10.1016/j.cct.2021.106491}
}
\author{
Chris J. Lloyd
}
