% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/exCon.R
\name{exCon}
\alias{exCon}
\title{Explore Contour Data Interactively}
\usage{
exCon(M = NULL, x = seq(0, 1, length.out = nrow(M)), y = seq(0, 1,
  length.out = ncol(M)), nlevels = 5, levels = pretty(range(M, na.rm =
  TRUE), nlevels), browser = NULL)
}
\arguments{
\item{M}{A matrix.}

\item{x}{A vector of numeric values giving the locations of the grid defining
the matrix.  Must have length \code{nrow(M)}.}

\item{y}{A vector of numeric values giving the locations of the grid defining
the matrix.  Must have length \code{ncol(M)}.}

\item{nlevels}{Integer.  The number of contour levels desired.  Ignored if \code{levels}
is given.}

\item{levels}{Numeric.  A vector of values (altitudes if you will) at which to
compute the contours.}

\item{browser}{Character.  Something that will make sense to your OS.  Only
necessary if you want to overide your system specified browser as understood by
\code{R}.  See below for further details.}
}
\value{
None; side effect is an interactive web page.  The temporary directory
containing the files that drive the web page is written to the console in case
you wish to use those files.  This directory is deleted when you quit R.
}
\description{
This function computes contour lines from matrix data and displays them
in an interactive web page using the d3 javascript library.
}
\section{Details}{
 The computation of the contour lines is handled by
\code{\link[grDevices]{contourLines}}.  The result here, however, is transposed so that the
output has the same orientation as the original matrix. This is necessary because
\code{\link[graphics]{contour}} tranposes its output: "Notice that
\code{contour} interprets the \code{z} matrix as a table of
\code{f(x[i], y[j])} values, so that the x axis corresponds to row number
and the y axis to column number, with column 1 at the bottom, i.e. a 90 degree
counter-clockwise rotation of the conventional textual layout."
}

\section{Interpretation}{
  The contour lines are an interpolation of the data
in the matrix.  The slices are the actual values in the matrix row or column
connected point-to-point.  Thus a maximum in a slice may not correspond to
a peak in the contour plot.
}

\section{Browser Choice}{
 The browser is called by
\code{\link[utils]{browseURL}}, which
in turn uses \code{options("browser")}.  Exactly how this is handled
is OS dependent.
}

\section{RStudio Viewer}{
 If browser is \code{NULL}, you are using RStudio, and a viewer is specified, this will be called.  You can stop this by with \code{options(viewer = NULL)}.
}

\section{Browser Choice/Mac}{
 On a Mac, the default browser is called
by \code{/bin/sh/open}
which in turn looks at which browser you have set in the system settings.  You can
override your default with
\code{browser = "/usr/bin/open -a 'Google Chrome'"} for example.
Testing shows that on a Mac, Safari and Chrome perform correctly,
but in Firefox the mouse cursor is slightly offset from the guides.  While it
doesn't look quite right, it works correctly (the guides determine which
slice is displayed).
}

\section{Browser Choice/Other Systems}{
  \code{exCon} has been tested
on a Windows 7
professional instance running in VirtualBox using Firefox and Chrome, and
runs correctly (Firefox has the same mouse position issue as mentioned above).
}

\section{Browser Choice & Performance}{
  You can check the performance of
your browser at peacekeeper.futuremark.com  The most relevant score for
exCon is the rendering category.  In limited testing, Chrome does the best.
}

\section{Performance Limits (YMMV)}{
 On a 4-year old MacBook Pro, with 8 Gb
RAM and an Intel Core i7 chip, a
4000 x 4000 matrix with 5 contour levels
requires about 30 seconds for R to create the contours.  The web page displayed
by
Chrome 38 appears to be about 85 Mb in size and the guide movements lag the mouse
movements quite a bit, but it is still usable.  Sometimes the page won't load.
The files on disk are about 159 Mb. Firefox 32 will load the 4K x 4K
matrix but performance is too sluggish. On the same computer, a
5000 x 5000 matrix with 5 contour levels
	causes Chrome to crash.  Testing on a newer Mac with 16 Gb RAMM shows that
the browser may be the limiting factor rather than the RAMM.
}
\examples{
require(jsonlite)
exCon(M = volcano)
}
\keyword{plot}

