% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combination_GRFN.R
\name{combination_GRFN}
\alias{combination_GRFN}
\title{Combination of Gaussian random fuzzy numbers}
\usage{
combination_GRFN(GRFN1, GRFN2, soft = TRUE)
}
\arguments{
\item{GRFN1}{A Gaussian random fuzzy number, encoded as a list with components mu, sig
and h.}

\item{GRFN2}{A Gaussian random fuzzy number, encoded as a list with components mu, sig
and h.}

\item{soft}{If TRUE (default), the combination rule with soft normalization is used.
Otherwise, hard normalization is employed.}
}
\value{
A list with two components:
\describe{
\item{GRFN}{The combined Gaussian random fuzzy number, encoded as a list with components
mu, sig and h.}
\item{conflict}{The degree of conflict (equal to 0 if \code{soft==TRUE}).}
}
}
\description{
\code{combination_GRFN} combines two Gaussian random fuzzy numbers using the generalized
product-intersection rule with soft or hard normalization.
}
\examples{
GRFN1<-list(mu=1,sig=1,h=2)
GRFN2<-list(mu=2,sig=2,h=3)
GRFN12s<-combination_GRFN(GRFN1,GRFN2) # soft normalization
GRFN12h<-combination_GRFN(GRFN1,GRFN2,soft=FALSE) # hard normalization
print(GRFN12s)
print(GRFN12h)
}
\references{
Thierry Denoeux. Reasoning with fuzzy and uncertain evidence using epistemic random
fuzzy sets: general framework and practical models. Fuzzy Sets and Systems, Vol. 453,
Pages 1-36, 2023.
}
\seealso{
\code{\link{Bel}}, \code{\link{Pl}}, \code{\link{pl_contour}}
}
