% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{divide_by_disconnection}
\alias{divide_by_disconnection}
\title{Divide sessions by disconnection day}
\usage{
divide_by_disconnection(
  sessions,
  division_hour,
  start = getOption("evprof.start.hour")
)
}
\arguments{
\item{sessions}{tibble, sessions data set in evprof
\href{https://mcanigueral.github.io/evprof/articles/sessions-format.html}{standard format}.}

\item{division_hour}{Hour to divide the groups according to disconnection time}

\item{start}{integer, start hour in the x axis of the plot.}
}
\value{
same sessions data set with extra column "Disconnection"
}
\description{
Divide sessions by disconnection day
}
\examples{
library(dplyr)
sessions_disconnection <- california_ev_sessions \%>\%
  sample_frac(0.05) \%>\%
  divide_by_disconnection(
    start = 2, division_hour = 5
  )

# The column `Disconnection` has been added
names(sessions_disconnection)

library(ggplot2)
sessions_disconnection \%>\%
  tidyr::drop_na() \%>\%
  plot_points() +
  facet_wrap(vars(Disconnection))

}
