test_that("MultiMahalanobis returns correct results on lists",
{
  mean.1 <- colMeans(matrix(rnorm(30*10), 30, 10))
  mean.2 <- colMeans(matrix(rnorm(30*10), 30, 10))
  mean.3 <- colMeans(matrix(rnorm(30*10), 30, 10))
  mean.list <- list(mean.1, mean.2, mean.3)
  euclidian <- MultiMahalanobis(mean.list, diag(rep(1, 10)))
  half.euclidian <- MultiMahalanobis(mean.list, diag(rep(0.5, 10)))
  expect_that((euclidian**2)*2, equals(half.euclidian**2))
  expect_that(euclidian, is_a("matrix"))
  expect_that(dim(euclidian), equals(c(3,3)))
  expect_that(euclidian[1,2], equals(sqrt(mahalanobis(mean.1, mean.2, diag(rep(1, 10))))))
  expect_that(euclidian[1,3], equals(sqrt(mahalanobis(mean.1, mean.3, diag(rep(1, 10))))))
  expect_true(isSymmetric(half.euclidian))
  cov_matrix = RandomMatrix(10, 1, 1, 10)
  random_dist = MultiMahalanobis(mean.list, cov_matrix)
  expect_that(random_dist[1,2], equals(sqrt(mahalanobis(mean.1, mean.2, cov_matrix))))
  expect_that(random_dist[1,3], equals(sqrt(mahalanobis(mean.1, mean.3, cov_matrix))))
  expect_true(isSymmetric(random_dist))
  expect_that(MultiMahalanobis(mean.list, array(1:100, c(10, 10))), throws_error("covariance matrix must be symmetric."))
}
)
test_that("MultiMahalanobis returns correct results on arrays",
{
  mean.1 <- colMeans(matrix(rnorm(30*10), 30, 10))
  mean.2 <- colMeans(matrix(rnorm(30*10), 30, 10))
  mean.3 <- colMeans(matrix(rnorm(30*10), 30, 10))
  mean.array <- rbind(mean.1, mean.2, mean.3)
  euclidian <- MultiMahalanobis(mean.array, diag(rep(1, 10)))
  half.euclidian <- MultiMahalanobis(mean.array, diag(rep(0.5, 10)))
  expect_that((euclidian**2)*2, equals(half.euclidian**2))
  expect_that(euclidian, is_a("matrix"))
  expect_that(dim(euclidian), equals(c(3,3)))
  expect_that(euclidian[1,2], equals(sqrt(mahalanobis(mean.1, mean.2, diag(rep(1, 10))))))
  expect_that(euclidian[1,3], equals(sqrt(mahalanobis(mean.1, mean.3, diag(rep(1, 10))))))
  expect_true(isSymmetric(half.euclidian))
  cov_matrix = RandomMatrix(10, 1, 1, 10)
  random_dist = MultiMahalanobis(mean.array, cov_matrix)
  expect_that(random_dist[1,2], equals(sqrt(mahalanobis(mean.1, mean.2, cov_matrix))))
  expect_that(random_dist[1,3], equals(sqrt(mahalanobis(mean.1, mean.3, cov_matrix))))
  expect_true(isSymmetric(random_dist))
  expect_that(MultiMahalanobis(mean.array, array(1:100, c(10, 10))), throws_error("covariance matrix must be symmetric."))
  expect_that(MultiMahalanobis(data.frame(mean.array), array(1:100, c(10, 10))), throws_error("means must be in a list or an array."))
}
)
