% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiMahalanobis.R
\name{MultiMahalanobis}
\alias{MultiMahalanobis}
\title{Calculate Mahalonabis distance for many vectors}
\usage{
MultiMahalanobis(means, cov.matrix, parallel = FALSE)
}
\arguments{
\item{means}{list or array of species means being compared. array must have means in the rows.}

\item{cov.matrix}{a single covariance matrix defining the scale (or metric tensor) to be used in the distance calculation.}

\item{parallel}{if TRUE computations are done in parallel. Some foreach backend must be registered, like doParallel or doMC.}
}
\value{
returns a matrix of species-species distances.
}
\description{
Calculates the Mahalanobis distance between a list of species mean, using a global covariance matrix
}
\examples{
mean.1 <- colMeans(matrix(rnorm(30*10), 30, 10))
mean.2 <- colMeans(matrix(rnorm(30*10), 30, 10))
mean.3 <- colMeans(matrix(rnorm(30*10), 30, 10))
mean.list <- list(mean.1, mean.2, mean.3)

# If cov.matrix is the identity, calculated distance is euclidian:
euclidian <- MultiMahalanobis(mean.list, diag(10))
# Using a matrix with half the variance will give twice the distance between each mean:
half.euclidian  <- MultiMahalanobis(mean.list, diag(10)/2) 

# Other covariance matrices will give different distances, measured in the scale of the matrix
non.euclidian <- MultiMahalanobis(mean.list, RandomMatrix(10))

#Input can be an array with means in each row
mean.array = array(1:36, c(9, 4))
mat = RandomMatrix(4)
MultiMahalanobis(mean.array, mat)

#Multiple threads can be used with some foreach backend library, like doMC or doParallel
#library(doParallel)
##Windows:
#cl <- makeCluster(2)
#registerDoParallel(cl)
##Mac and Linux:
#registerDoParallel(cores = 2)
#MultiMahalanobis(mean.list, RandomMatrix(10), parallel = TRUE)
}
\references{
http://en.wikipedia.org/wiki/Mahalanobis_distance
}
\seealso{
\code{\link{mahalanobis}}
}
\author{
Diogo Melo
}
