% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglik.surface.OUBM.R
\name{loglik.surface.OUBM}
\alias{loglik.surface.OUBM}
\title{Calculate the log-likelihood surface for a part of parameter space}
\usage{
loglik.surface.OUBM(
  y,
  stat.var.vec,
  h.vec,
  anc = NULL,
  theta.0 = NULL,
  vo = NULL,
  opt.anc = TRUE,
  pool = TRUE
)
}
\arguments{
\item{y}{an univariate paleoTS object.}

\item{stat.var.vec}{vector containing the parameter values of the stationary variance to be evaluated}

\item{h.vec}{vector containing the parameter values of the half life to be evaluated}

\item{anc}{the ancestral state}

\item{theta.0}{the optimum}

\item{vo}{the variance (vstep) parameter for the optimum}

\item{opt.anc}{logical, indicating whether the the ancestral trait state is at the optimum.}

\item{pool}{indicating whether to pool variances across samples}
}
\value{
the function returns the range of parameter values that are within two log-likelihood units from the best (maximum) parameter estimate and a log-likelihood surface.
}
\description{
Function to calculate the log-likelihood surface for a part of parameter space for a Ornstein-Uhlenbeck model where the optimum changes according to an Unbiased Random Walk.
}
\note{
How fine-scaled the estimated log-likelihood surface is depends on the step size between the values in the input-vectors. The step-size therefore determines how accurate the representation of the support surface is, including the returned upper and lower estimates printed in the console. The range of the input vectors needs to be increased if the confidence interval includes the boundary of the input vector. Note also that it might be wise to include the maximum likelihood estimates as part of the input vectors. The computed support surface is conditional on the best estimates of the other model parameters that are not part of the support surface (e.g. the estimated ancestral trait value).
}
\examples{

## Generate a paleoTS objects
x <- sim.OUBM(40)

## Fit the model.
x1<-opt.joint.OUBM(x)

##calculate half-life from model output
log(2)/x1$parameters[3]

##calculate stationary variance from model output
x1$parameters[2]/(2*x1$parameters[3])

\donttest{
## Create log-likelihood surface (the example may take > 5 seconds to run)
loglik.surface.OUBM(x, stat.var.vec=seq(0,4,0.01), h.vec=seq(0.0,5, 0.1))
}
}
\author{
Kjetil Lysne Voje
}
