\name{betagpd}
\alias{betagpd}
\alias{dbetagpd}
\alias{pbetagpd}
\alias{qbetagpd}
\alias{rbetagpd}
\title{Beta Bulk and GPD Tail Extreme Value Mixture Model}
\usage{
  dbetagpd(x, bshape1 = 1, bshape2 = 1,
    u = qbeta(0.9, bshape1, bshape2),
    sigmau = sqrt(bshape1 * bshape2/(bshape1 + bshape2)^2/(bshape1 + bshape2 + 1)),
    xi = 0, phiu = TRUE, log = FALSE)

  pbetagpd(q, bshape1 = 1, bshape2 = 1,
    u = qbeta(0.9, bshape1, bshape2),
    sigmau = sqrt(bshape1 * bshape2/(bshape1 + bshape2)^2/(bshape1 + bshape2 + 1)),
    xi = 0, phiu = TRUE, lower.tail = TRUE)

  qbetagpd(p, bshape1 = 1, bshape2 = 1,
    u = qbeta(0.9, bshape1, bshape2),
    sigmau = sqrt(bshape1 * bshape2/(bshape1 + bshape2)^2/(bshape1 + bshape2 + 1)),
    xi = 0, phiu = TRUE, lower.tail = TRUE)

  rbetagpd(n = 1, bshape1 = 1, bshape2 = 1,
    u = qbeta(0.9, bshape1, bshape2),
    sigmau = sqrt(bshape1 * bshape2/(bshape1 + bshape2)^2/(bshape1 + bshape2 + 1)),
    xi = 0, phiu = TRUE)
}
\arguments{
  \item{bshape1}{beta shape 1 (positive)}

  \item{bshape2}{beta shape 2 (positive)}

  \item{u}{threshold over \eqn{(0, 1)}}

  \item{phiu}{probability of being above threshold \eqn{[0,
  1]} or \code{TRUE}}

  \item{x}{quantiles}

  \item{sigmau}{scale parameter (positive)}

  \item{xi}{shape parameter}

  \item{log}{logical, if TRUE then log density}

  \item{q}{quantiles}

  \item{lower.tail}{logical, if FALSE then upper tail
  probabilities}

  \item{p}{cumulative probabilities}

  \item{n}{sample size (positive integer)}
}
\value{
  \code{\link[evmix:betagpd]{dbetagpd}} gives the density,
  \code{\link[evmix:betagpd]{pbetagpd}} gives the
  cumulative distribution function,
  \code{\link[evmix:betagpd]{qbetagpd}} gives the quantile
  function and \code{\link[evmix:betagpd]{rbetagpd}} gives
  a random sample.
}
\description{
  Density, cumulative distribution function, quantile
  function and random number generation for the extreme
  value mixture model with beta for bulk distribution upto
  the threshold and conditional GPD above threshold. The
  parameters are the beta shape 1 \code{bshape1} and shape
  2 \code{bshape2}, threshold \code{u} GPD scale
  \code{sigmau} and shape \code{xi} and tail fraction
  \code{phiu}.
}
\details{
  Extreme value mixture model combining beta distribution
  for the bulk below the threshold and GPD for upper tail.

  The user can pre-specify \code{phiu} permitting a
  parameterised value for the tail fraction \eqn{\phi_u}.
  Alternatively, when \code{phiu=TRUE} the tail fraction is
  estimated as the tail fraction from the beta bulk model.

  The usual beta distribution is defined over \eqn{[0, 1]},
  but this mixture is generally not limited in the upper
  tail \eqn{[0,\infty]}, except for the usual upper tail
  limits for the GPD when \code{xi<0} discussed in
  \code{\link[evmix:gpd]{gpd}}. Therefore, the threshold is
  limited to \eqn{(0, 1)}.

  The cumulative distribution function with tail fraction
  \eqn{\phi_u} defined by the upper tail fraction of the
  beta bulk model (\code{phiu=TRUE}), upto the threshold
  \eqn{0 \le x \le u < 1}, given by: \deqn{F(x) = H(x)} and
  above the threshold \eqn{x > u}: \deqn{F(x) = H(u) + [1 -
  H(u)] G(x)} where \eqn{H(x)} and \eqn{G(X)} are the beta
  and conditional GPD cumulative distribution functions
  (i.e. \code{pbeta(x, bshape1, bshape2)} and \code{pgpd(x,
  u, sigmau, xi)}).

  The cumulative distribution function for pre-specified
  \eqn{\phi_u}, upto the threshold \eqn{0 \le x \le u < 1},
  is given by: \deqn{F(x) = (1 - \phi_u) H(x)/H(u)} and
  above the threshold \eqn{x > u}: \deqn{F(x) = \phi_u + [1
  - \phi_u] G(x)} Notice that these definitions are
  equivalent when \eqn{\phi_u = 1 - H(u)}.

  See \code{\link[evmix:gpd]{gpd}} for details of GPD upper
  tail component and \code{\link[stats:Beta]{dbeta}} for
  details of beta bulk component.
}
\note{
  All inputs are vectorised except \code{log} and
  \code{lower.tail}. The main inputs (\code{x}, \code{p} or
  \code{q}) and parameters must be either a scalar or a
  vector. If vectors are provided they must all be of the
  same length, and the function will be evaluated for each
  element of vector. In the case of
  \code{\link[evmix:betagpd]{rbetagpd}} any input vector
  must be of length \code{n}.

  Default values are provided for all inputs, except for
  the fundamentals \code{x}, \code{q} and \code{p}. The
  default sample size for
  \code{\link[evmix:betagpd]{rbetagpd}} is 1.

  Missing (\code{NA}) and Not-a-Number (\code{NaN}) values
  in \code{x}, \code{p} and \code{q} are passed through as
  is and infinite values are set to \code{NA}. None of
  these are not permitted for the parameters.

  Error checking of the inputs (e.g. invalid probabilities)
  is carried out and will either stop or give warning
  message as appropriate.
}
\examples{
\dontrun{
par(mfrow=c(2,2))
x = rbetagpd(1000, bshape1 = 1.5, bshape2 = 2, u = 0.7, phiu = 0.2)
xx = seq(-0.1, 2, 0.01)
hist(x, breaks = 100, freq = FALSE, xlim = c(-0.1, 2))
lines(xx, dbetagpd(xx, bshape1 = 1.5, bshape2 = 2, u = 0.7, phiu = 0.2))

# three tail behaviours
plot(xx, pbetagpd(xx, bshape1 = 1.5, bshape2 = 2, u = 0.7, phiu = 0.2), type = "l")
lines(xx, pbetagpd(xx, bshape1 = 1.5, bshape2 = 2, u = 0.7, phiu = 0.2, xi = 0.3), col = "red")
lines(xx, pbetagpd(xx, bshape1 = 1.5, bshape2 = 2, u = 0.7, phiu = 0.2, xi = -0.3), col = "blue")
legend("bottomright", paste("xi =",c(0, 0.3, -0.3)),
  col=c("black", "red", "blue"), lty = 1)

x = rbetagpd(1000, bshape1 = 2, bshape2 = 0.8, u = 0.7, phiu = 0.5)
hist(x, breaks = 100, freq = FALSE, xlim = c(-0.1, 2))
lines(xx, dbetagpd(xx, bshape1 = 2, bshape2 = 0.6, u = 0.7, phiu = 0.5))

plot(xx, dbetagpd(xx, bshape1 = 2, bshape2 = 0.8, u = 0.7, phiu = 0.5, xi=0), type = "l")
lines(xx, dbetagpd(xx, bshape1 = 2, bshape2 = 0.8, u = 0.7, phiu = 0.5, xi=-0.2), col = "red")
lines(xx, dbetagpd(xx, bshape1 = 2, bshape2 = 0.8, u = 0.7, phiu = 0.5, xi=0.2), col = "blue")
legend("topright", c("xi = 0", "xi = 0.2", "xi = -0.2"),
  col=c("black", "red", "blue"), lty = 1)
}
}
\author{
  Yang Hu and Carl Scarrott
  \email{carl.scarrott@canterbury.ac.nz}
}
\references{
  \url{http://en.wikipedia.org/wiki/Beta_distribution}

  \url{http://en.wikipedia.org/wiki/Generalized_Pareto_distribution}

  Scarrott, C.J. and MacDonald, A. (2012). A review of
  extreme value threshold estimation and uncertainty
  quantification. REVSTAT - Statistical Journal 10(1),
  33-59. Available from
  \url{http://www.ine.pt/revstat/pdf/rs120102.pdf}

  MacDonald, A. (2012). Extreme value mixture modelling
  with medical and industrial applications. PhD thesis,
  University of Canterbury, New Zealand.
  \url{http://ir.canterbury.ac.nz/bitstream/10092/6679/1/thesis_fulltext.pdf}
}
\seealso{
  \code{\link[evmix:gpd]{gpd}} and
  \code{\link[stats:Beta]{dbeta}}

  Other betagpd betagpdcon fbetagpd fbetagpdcon:
  \code{\link{betagpdcon}}, \code{\link{dbetagpdcon}},
  \code{\link{pbetagpdcon}}, \code{\link{qbetagpdcon}},
  \code{\link{rbetagpdcon}}
}

