% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{colplot}
\alias{colplot}
\title{Scatter plot, with variable-based point colours}
\usage{
colplot(
  x,
  y,
  z,
  n = 20,
  rev = TRUE,
  cex = 1,
  pch = 21,
  add = FALSE,
  breaks = NULL
)
}
\arguments{
\item{x}{a vector of x coordinates}

\item{y}{a vector of y coordinates}

\item{z}{a variable for defining colours}

\item{n}{an integer giving the number of colour levels, supplied to \link[base]{pretty}}

\item{rev}{logical: should the palette be reversed? Defaults to \code{TRUE}}

\item{cex}{a scalar for character expansion, supplied to \link[graphics]{plot}}

\item{pch}{an integer giving the plotting character, supplied to \link[graphics]{plot}}

\item{add}{logical: add to an existing plot? Defaults to \code{FALSE}}

\item{breaks}{a vector or breaks for defining color intervals; defaults to \code{NULL}, so \link[base]{pretty} and \code{n} are used on \code{z}}
}
\value{
A plot
}
\description{
Scatter plot, with variable-based point colours
}
\examples{

x <- runif(50)
y <- runif(50)
colplot(x, y, x * y)

}
