% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnevclus_mb.R
\name{nnevclus_mb}
\alias{nnevclus_mb}
\title{NN-EVCLUS algorithm (minibatch version)}
\usage{
nnevclus_mb(
  x,
  foncD = function(x) as.matrix(dist(x)),
  c,
  type = "simple",
  n_H,
  nbatch = 10,
  alpha0 = 0.9,
  fhat = NULL,
  lambda = 0,
  y = NULL,
  Is = NULL,
  nu = 0,
  disp = TRUE,
  options = list(Niter = 1000, epsi = 0.001, rho = 0.9, delta = 1e-08, Dtmax = 100,
    print = 5),
  param0 = list(V0 = NULL, W0 = NULL, beta0 = NULL)
)
}
\arguments{
\item{x}{nxp matrix of p attributes observed for n objects.}

\item{foncD}{A function to compute distances.}

\item{c}{Number of clusters}

\item{type}{Type of focal sets ("simple": empty set, singletons and Omega;
"full": all \eqn{2^c} subsets of \eqn{\Omega}; "pairs": \eqn{\emptyset}, singletons,
\eqn{\Omega}, and all or selected pairs).}

\item{n_H}{Size or the hidden layer.}

\item{nbatch}{Number of mini-batches.}

\item{alpha0}{Order of the quantile to normalize distances. Parameter d0 is set to 
the alpha0-quantile of distances. Default: 0.9.}

\item{fhat}{Vector of outputs from a one-class SVM for novelty detection (optional)}

\item{lambda}{Regularization coefficient (default: 0)}

\item{y}{Optional vector of class labels for a subset of the training set 
(for semi-supervised learning).}

\item{Is}{Vector of indices corresponding to y (for semi-supervised learning).}

\item{nu}{Coefficient of the supervised error term (default: 0).}

\item{disp}{If TRUE, intermediate results are displayed.}

\item{options}{Parameters of the optimization algorithm (Niter: maximum number of
iterations; epsi, rho, delta: parameters of RMSprop; Dtmax: the algorithm stops when
the loss has not decreased in the last Dtmax iterations; print: number of iterations 
between two displays).}

\item{param0}{Optional list of initial network parameters (see details).

#'}
}
\value{
The output credal partition (an object of class \code{"credpart"}). In 
addition to the usual attributes, the output credal partition has the following 
attributes:
 \describe{
  \item{Kmat}{The matrix of degrees of conflict. Same size as D.}
  \item{trace}{Trace of the algorithm (values of the loss function).}
  \item{param}{The network parameters as a list with components V, W and beta.}
 }
}
\description{
\code{nnevclus_mb} computes a credal partition from a dissimilarity matrix using the 
NN-EVCLUS algorithm. Training is done using mini-batch gradient descent with the RMSprop
optimization algorithm.
}
\details{
This is a neural network version of \code{kevclus}. The neural net has one layer
of ReLU units and a softmax output layer (see Denoeux, 2020). The network is trained
in mini-batch mode using the RMSprop algorithm. The inputs are a feature vector x, 
an optional distance matrix D, and an optional vector of one-class SVM outputs fhat, 
which is used for novelty detection. Part of the output belief mass is transfered to 
the empty set based on beta[1]+beta[2]*fhat, where beta is an additional parameter 
vector. The network can be trained in fully unsupervised mode or in semi-supervised mode
(with class labels for a subset of the learning instances). The output is a credal 
partition (a "credpart" object), with a specific field containing the network parameters (U, V, W,
beta).
}
\examples{
\dontrun{
## Unsupervised learning
data(fourclass)
x<-scale(fourclass[,1:2])
y<-fourclass[,3]
svmfit<-ksvm(~.,data=x,type="one-svc",kernel="rbfdot",nu=0.2,kpar=list(sigma=0.2))
fhat<-predict(svmfit,newdata=x,type="decision")
clus<-nnevclus_mb(x,foncD=function(x) as.matrix(dist(x)),c=4,type='pairs',
n_H=10,nbatch=10,alpha0=0.9,fhat=fhat)
plot(clus,x)
## semi-supervised learning
Is<-sample(400,100)
clus<-nnevclus_mb(x,foncD=function(x) as.matrix(dist(x)),c=4,type='pairs',
n_H=10,nbatch=10,alpha0=0.9,fhat=fhat,lambda=0, y=y[Is],Is=Is,nu=0.5)
plot(clus,x)
}

}
\references{
T. Denoeux. NN-EVCLUS: Neural Network-based Evidential Clustering. 
arXiv:2009.12795, 2020.
}
\seealso{
\code{\link{nnevclus}}, \code{\link{predict.credpart}}, 
\code{\link{kevclus}}, \code{\link{kcevclus}}, \code{\link{harris}}
}
\author{
Thierry Denoeux.
}
