% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proDSval.R
\name{proDSval}
\alias{proDSval}
\title{Classification of a test set by the evidential neural network classifier}
\usage{
proDSval(x, param, y = NULL)
}
\arguments{
\item{x}{Matrix of size n x d, containing the values of the d attributes for the test data.}

\item{param}{Neural network parameters, as provided by \code{\link{proDSfit}}.}

\item{y}{Optional vector of class labels for the test data. May be a factor, or a vector of
integers from 1 to M (number of classes).}
}
\value{
A list with three elements:
  \describe{
  \item{m}{Predicted mass functions for the test data. The first M columns correspond
  to the mass assigned to each class. The last column corresponds to the mass
  assigned to the whole set of classes.}
  \item{ypred}{Predicted class labels for the test data.}
  \item{err}{Test error rate (if the class label of test data has been provided).}
 }
}
\description{
\code{proDSval} classifies instances in a test set using the evidential neural network classifier.
}
\details{
If class labels for the test set are provided, the test error rate is also returned.
}
\examples{
## Glass dataset
data(glass)
xapp<-glass$x[1:89,]
yapp<-glass$y[1:89]
xtst<-glass$x[90:185,]
ytst<-glass$y[90:185]
## Initialization
param0<-proDSinit(xapp,yapp,nproto=7)
## Training
fit<-proDSfit(xapp,yapp,param0)
## Test
val<-proDSval(xtst,fit$param,ytst)
## Confusion matrix
table(ytst,val$ypred)
}
\references{
T. Denoeux. A neural network classifier based on Dempster-Shafer theory.
IEEE Trans. on Systems, Man and Cybernetics A, 30(2):131--150, 2000.

Available from \url{https://www.hds.utc.fr/~tdenoeux}.
}
\seealso{
\code{\link{proDSinit}}, \code{\link{proDSfit}}
}
\author{
Thierry Denoeux.
}
