% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_latent_trawl.R
\name{UnivariateFullPL}
\alias{UnivariateFullPL}
\title{Computes univariate latent trawl FULL pairwise likelihood depending with
exponential trawl function with the option to fix some parameter values.}
\usage{
UnivariateFullPL(times, values, delta, fixed_names, fixed_params, params,
  model_vars_names, logscale = T, transformation = F)
}
\arguments{
\item{times}{Vector of timestamps.}

\item{values}{Vector of target values.}

\item{delta}{Maximum depth of pairwise likelihood blocks. Should be positive
natural integer.}

\item{fixed_names}{Vector of literal names of parameters to keep fixed.}

\item{fixed_params}{Vector of numerical values of fixed parameters.}

\item{params}{List of parameters.}

\item{model_vars_names}{Vector of all parameters names in the model.}

\item{logscale}{Boolean to use logscale (log-likelihood). Default \code{T}.}

\item{transformation}{Boolean to use the Marginal Transform (MT) method.}
}
\value{
FULL latent trawl pairwise likelihood with some (or none) parameters
  fixed.
}
\description{
Computes univariate latent trawl FULL pairwise likelihood depending with
exponential trawl function with the option to fix some parameter values.
}
\examples{
times <- c(1,2,3,4,5)
values <- c(2,0,3,4,0)
delta <- 2
fixed_names <- c("alpha", "beta")
fixed_params <- c(2.0, 3.4)
params <- c(0.1, 4.3)
model_vars_names <- c("alpha", "beta", "rho", "kappa")
UnivariateFullPL(times, values, delta, fixed_names, fixed_params,
params, model_vars_names, TRUE, FALSE)

}
