% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eurostat_raw2.R
\name{get_eurostat_raw2}
\alias{get_eurostat_raw2}
\title{Download Data from Eurostat Dissemination API}
\usage{
get_eurostat_raw2(id)
}
\arguments{
\item{id}{A code name for the dataset of interested. See the table of
contents of eurostat datasets for more details.}
}
\value{
A dataset in tibble format. First column contains comma
separated codes of cases. Other columns usually corresponds to
years and column names are years with preceding X. Data is in
character format as it contains values together with eurostat
flags for data.
}
\description{
Download data from the eurostat database through the new
dissemination API.
}
\details{
Data is downloaded from
\url{https://ec.europa.eu/eurostat/estat-navtree-portlet-prod/BulkDownloadListing}
and transformed into tabular format.
}
\examples{
\dontshow{if (check_access_to_data()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
eurostat:::get_eurostat_raw("educ_iste")
}
\dontshow{\}) # examplesIf}
}
\references{
See \code{citation("eurostat")}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# 
# Kindly cite the eurostat R package as follows:
# 
#   (C) Leo Lahti, Janne Huovari, Markus Kainu, Przemyslaw Biecek.
#   Retrieval and analysis of Eurostat open data with the eurostat
#   package. R Journal 9(1):385-392, 2017. doi: 10.32614/RJ-2017-019
#   Package URL: http://ropengov.github.io/eurostat Article URL:
#   https://journal.r-project.org/archive/2017/RJ-2017-019/index.html
# 
# A BibTeX entry for LaTeX users is
# 
#   @Article\{,
#     title = \{Retrieval and Analysis of Eurostat Open Data with the eurostat Package\},
#     author = \{Leo Lahti and Janne Huovari and Markus Kainu and Przemyslaw Biecek\},
#     journal = \{The R Journal\},
#     volume = \{9\},
#     number = \{1\},
#     pages = \{385--392\},
#     year = \{2017\},
#     doi = \{10.32614/RJ-2017-019\},
#     url = \{https://doi.org/10.32614/RJ-2017-019\},
#   \}
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=get_eurostat]{get_eurostat()}}.
}
\author{
Przemyslaw Biecek, Leo Lahti, Janne Huovari and Pyry Kantanen
}
\keyword{database}
\keyword{utilities}
