% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{etcd}
\alias{etcd}
\title{etseed client}
\usage{
etcd(host = "127.0.0.1", port = 2379, api_version = "v2",
  allow_redirect = TRUE, scheme = "http")
}
\arguments{
\item{host}{(character) Host url. Deafault: 127.0.0.1}

\item{port}{(character/numeric) Port. Default: 2379}

\item{api_version}{(characrter) etcd API version. Default: 'v2'}

\item{allow_redirect}{(logical) Allow redirects? Default: \code{TRUE}}

\item{scheme}{(character) http scheme, one of http or https. Default: http}
}
\value{
Various output, see help files for each grouping of methods.
}
\description{
etseed client
}
\details{
\code{etcd} creates a R6 class object. The object is
not cloneable and is portable, so it can be inherited across packages
without complication.

\code{etcd} is used to initialize a client that knows about your etcd
instance, with options for setting host, port, etcd api version,
whether to allow redirects, and the http scheme.
}
\section{etcd methods}{

\strong{Methods}
  \describe{
    \item{\code{ping()}}{
     ping the etcd server
    }
    \item{\code{version()}}{
     check the etcd version
    }
    \item{\code{keys()}}{
     list keys, see also \code{\link{keys}}
    }
    \item{\code{key()}}{
     get a key, see also \code{\link{keys}}
    }
    \item{\code{create()}}{
     create a key, see also \code{\link{keys}}
    }
    \item{\code{delete()}}{
     delete a key, see also \code{\link{keys}}
    }
    \item{\code{update()}}{
     update a key, see also \code{\link{keys}}
    }
    \item{\code{create_inorder()}}{
     create a key in order, see also \code{\link{keys}}
    }
    \item{\code{metrics()}}{
     see metrics, see also \code{\link{metrics}}
    }
    \item{\code{stats()}}{
     see stats, see also \code{\link{stats}}
    }
    \item{\code{user_add()}}{
     add a user, see also \code{\link{users}}
    }
    \item{\code{user_list()}}{
     list users, see also \code{\link{users}}
    }
    \item{\code{user_get()}}{
     get a user, see also \code{\link{users}}
    }
    \item{\code{user_delete()}}{
     delete a user, see also \code{\link{users}}
    }
    \item{\code{member_list()}}{
     list members, see also \code{\link{members}}
    }
    \item{\code{member_add()}}{
     add a member, see also \code{\link{members}}
    }
    \item{\code{member_change()}}{
     change a member, see also \code{\link{members}}
    }
    \item{\code{member_delete()}}{
     delete a member, see also \code{\link{members}}
    }
    \item{\code{role_add()}}{
     add a role, see also \code{\link{roles}}
    }
    \item{\code{role_list()}}{
     list roles, see also \code{\link{roles}}
    }
    \item{\code{role_get()}}{
     get a role, see also \code{\link{roles}}
    }
    \item{\code{role_delete()}}{
     delete a role, see also \code{\link{roles}}
    }
    \item{\code{auth_status()}}{
     authentication status, see also \code{\link{auth}}
    }
    \item{\code{auth_enable()}}{
     enable authentication, see also \code{\link{auth}}
    }
    \item{\code{auth_disable()}}{
     disable authentication, see also \code{\link{auth}}
    }
  }
}
\examples{
\dontrun{
# make a client
cli <- etcd()

# ping
## ping to make sure it's up
cli$ping()

# version
## get etcd version information
cli$version()

# etcd variables
cli$host
cli$port
cli$api_version
cli$allow_redirect
cli$scheme

# set a different host
etcd(host = 'stuff.com')

# set a different port
etcd(host = 3456)

# set a different etcd API version
etcd(host = 'v3')

# set a different http scheme
etcd(scheme = 'https')

# don't allow redirects
etcd(allow_redirect = FALSE)
}
}

