% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ess_all_rounds.R
\name{ess_all_rounds}
\alias{ess_all_rounds}
\title{Download all available integrated rounds from the European Social Survey}
\usage{
ess_all_rounds(your_email, only_download = FALSE, output_dir = NULL)
}
\arguments{
\item{your_email}{a character vector with your email, such as "your_email@email.com".
If you haven't registered in the ESS website, create an account at 
\url{http://www.europeansocialsurvey.org/user/new}}

\item{only_download}{whether to only download the files as Stata files. Defaults to FALSE.}

\item{output_dir}{a character vector with the output directory in case you want to only download the files using
the \code{only_download} argument. Defaults to NULL because data is not saved by default.}
}
\value{
if \code{only_download} is set to FALSE it returns a list containing the
latest version of each round. If \code{only_download} is set to TRUE and
output_dir is a valid directory, it returns the saved directories invisibly and saves
all the rounds in .dta format in \code{output_dir}
}
\description{
Download all available integrated rounds from the European Social Survey
}
\examples{

\dontrun{

# Will download all rounds and return a list with each one
ess_all_rounds("your_email@gmail.com")

# Will download all rounds to the directory below
# as .dta files and won't return the rounds in R.

dl_dir <- file.path(tempdir(), "mydownloads")

ess_all_rounds("your_email@gmail.com", only_download = TRUE, output_dir = dl_dir)
}

}
