% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_2D_histo.R
\name{display.2D.histo}
\alias{display.2D.histo}
\title{Display of a 2D histogram}
\usage{
display.2D.histo(
  histo.2D,
  add = TRUE,
  main = NULL,
  x.lab = NULL,
  y.lab = NULL,
  x.lim = NULL,
  y.lim = NULL,
  bg = "#000000",
  i.rng = NULL,
  display.mode = c("mono.color", "rainbow.color", "line"),
  col = "#ffffff",
  alpha = 1,
  line.pc.levels = c(1, 100),
  line.lwd = 2,
  line.lty = 1
)
}
\arguments{
\item{histo.2D}{"histo2D" class object.}

\item{add}{Boolean indicating whether to display the background image.}

\item{main}{Title of the background image. If \code{main = NULL},
the title indicates "2D histogram".}

\item{x.lab}{Label of the x-axis of the background image. If \code{x.lab = NULL},
this label is \code{histo.2D$x.file.src}}

\item{y.lab}{Label of the y-axis of the background image. If \code{y.lab = NULL},
this label is \code{histo.2D$y.file.src}.}

\item{x.lim}{Vector, representing the range of the x-axis.}

\item{y.lim}{Vector, representing the range of the y-axis.}

\item{bg}{Background color of the image. By default, this color is black.}

\item{i.rng}{Vector of 2 elements giving the minimum and the maximum intensity
of the image. If \code{i.rng = NULL}, then the minimum is 0 and the maximum the
maximum density.}

\item{display.mode}{function display mode. See Details.}

\item{col}{Color of the color gradient in \code{display.mode = "mono.color"},
or of the level lines in \code{display.mode = "line"}. By default, this color
is white.}

\item{alpha}{A number from 0 to 1, indicating the opacity of the image in
\code{"rainbow.color"} mode. Default alpha = 1.}

\item{line.pc.levels}{Vector of level lines in percent of maximum density
in \code{display.mode = "line"}. By default lines 1\% and 100\% are displayed.}

\item{line.lwd}{Line thickness of the level lines in \code{display.mode = "line"}.}

\item{line.lty}{Type of lines for level lines in \code{display.mode = "line"}.}
}
\value{
Returns a display of the density map of \code{histo.2D}. This one must
be an object of class "histo2D". See \link[espadon]{espadon.class} for
class definitions.
}
\description{
The \code{display.2D.histo} function displays the density map of
a "histo2D" class object.
}
\details{
The \code{display.mode} argument can be set to three values:
\code{"mono.color"}, \code{"rainbow.color"}, or \code{"line"}. The 2D
histogram graph is displayed by default in \code{"mono.color"} mode.
\itemize{
\item The \code{"mono.color"} mode displays a gradient of the color defined
by the col argument, depending on the intensity of \code{$density.map} 2-dimensional
array.
\item The \code{"rainbow.color"} mode makes a display according to the
\code{"rainbow"} palette, while managing the opacity of the colors.
\item The \code{"line"} mode draws level lines defined in percent by the
\code{line.pc.levels} argument.
}
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 4
patient <- toy.load.patient (modality = c("ct", "mr", "rtstruct"), 
                             roi.name =  "brain", 
                             dxyz = rep (step, 3))
CT <- patient$ct[[1]]
MR <- patient$mr[[1]]
S <- patient$rtstruct[[1]]
T.MAT <- patient$T.MAT

# restriction of the volume around the RoI
CT.on.roi <- nesting.roi (CT, S, roi.name = "brain", vol.restrict = TRUE,
                          xyz.margin = c (1, 1, 1), alias = CT$description)
MR.on.CT <- vol.regrid (vol = MR, back.vol = CT.on.roi, interpolate = TRUE,
                        T.MAT = T.MAT, alias = CT$description,
                        description = NULL)
# selection of voxels included in the RoI.
roi.bin <- bin.from.roi (vol = CT.on.roi, struct = S, roi.sname = "brain")
MR.select <- vol.from.bin (MR.on.CT, roi.bin, alias = MR$description)
CT.select <- vol.from.bin (CT.on.roi, roi.bin, alias = CT$description)
# 2D histogram
H2D <- histo.2D (MR.select, CT.select, x.breaks = seq (50, 400, 10),
			  y.breaks = seq (50, 400, 10), alias = "H2D MR1 MR2")
display.2D.histo (H2D, display.mode = "mono.color", col = "#ffff00", 
                  main ="mono color mode")
display.2D.histo (H2D, display.mode = "rainbow.color", main ="rainbow mode")
display.2D.histo (H2D, display.mode = "line", main ="level lines mode",
                  line.pc.levels = c (0, 25, 50, 75, 100), col = "#ff0000")
}
\seealso{
\link[espadon]{histo.2D}.
}
