% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histo_from_roi.R
\name{histo.from.roi}
\alias{histo.from.roi}
\title{Histogram according to a RoI}
\usage{
histo.from.roi(
  vol,
  struct,
  roi.name = NULL,
  roi.sname = NULL,
  roi.idx = NULL,
  T.MAT = NULL,
  breaks = NULL,
  MC = NULL,
  sd = c(1, 1, 1),
  offset = c(0, 0, 0),
  over.sampling.factor = 1,
  alias = "",
  description = NULL
)
}
\arguments{
\item{vol}{"volume" class object}

\item{struct}{"struct" class object.}

\item{roi.name}{Exact name of a RoI in \code{struct} object. By default
\code{roi.name = NULL}. See Details.}

\item{roi.sname}{Name or part of name of a RoI in \code{struct} object.
By default \code{roi.sname = NULL}. See Details.}

\item{roi.idx}{Value of the index of a RoI that belong to the \code{struct}
object. By default \code{roi.idx = NULL}. See Details.}

\item{T.MAT}{"t.mat" class object, created by \link[espadon]{load.patient.from.Rdcm},
\link[espadon]{load.patient.from.dicom} or \link[espadon]{load.T.MAT}. If
\code{T.MAT = NULL}, \code{struct$ref.pseudo} must be equal to
\code{vol$ref.pseudo}.}

\item{breaks}{Vector giving the breakpoints between histogram cells. If
\code{breaks = NULL}, the chosen breakpoints are those used by the
\link[graphics]{hist} function by default. If \code{breaks} are specified,
outside values of \code{vol$vol3D.data} are not taken into account.}

\item{MC}{If different from \code{NULL} (default value), number of calculations
that will be performed, by Monte-Carlo, by randomly moving the chosen RoI
over a random distance, generated according to a normal distribution with
mean translation defined by \code{offset} and
standard deviation \code{sd}.}

\item{sd}{Vector representing the standard deviation of distances in the 3
directions x, y and z.}

\item{offset}{Vector representing the translation of the RoI in the 3
directions x, y and z.}

\item{over.sampling.factor}{Strictly positive integer, or a vector of 3 strictly
positive integers, default to 1. Defined to oversample grids of \code{vol}.
Oversampling can be very time consuming.}

\item{alias}{Character string, \code{$alias} of the created object}

\item{description}{Character string, describing the the created object. If
the \code{description = NULL} (default value), it will be set to
\code{struct$roi.info$roi.pseudo[roi.idx]}}
}
\value{
Returns "histo" class object. This is a list including:
\itemize{
\item \code{$alias}: alias of the histo object.
\item \code{$description}: description of the histo object.
\item \code{$breaks}: vector breakpoints
\item \code{$mids}: vector of cell centers.
\item \code{$mids.unit}: Character string, representing the unit of the abcissa
of the histogram. For instance, "Gy", when \code{vol} is a rtdose.
\item \code{counts}: count of voxels whose value is included in the limits
defined by \code{$breaks}.
\item \code{dV_dx}: differential histogram, expressed in cm3 by voxel units,
at each \code{$mids}.
\item \code{MC.counts}: array of \code{MC} rows. Each row \code{i} represents
the histogram of the voxels
contained in the RoI, whose points have been shifted by \code{$MC.dxyz[i,]}.
\item \code{MC.dV_dx}: array of \code{MC} rows. Each row \code{i} represents
the differential histogram
of the voxels contained in the RoI, the points of which have been shifted by
\code{$MC.dxyz[i,]}.
\item \code{MC.dxyz}: array of \code{MC} rows, representing the offset applied
to the RoI.
}
}
\description{
The \code{histo.from.roi} function calculates the histogram of
the volume voxels belonging to a RoI.
}
\details{
\code{roi.name}, \code{roi.sname}, and \code{roi.idx} must select
only one RoI.
}
\note{
Using Monte-Carlo can be time consuming for large RoI.

If you only want the result just for a translation, use the arguments
\code{MC = 1}, \code{sd = 0} and \code{offset =} desired translation vector.
}
\examples{
# loading of toy-patient objects (decrease dxyz and increase beam.nb for better
# result)
step <- 5
patient <- toy.load.patient (modality = c("rtdose", "rtstruct"), 
                             roi.name = "gizzard", dxyz = rep (step, 3), 
                             beam.nb = 3)

# Calculation of the histogram
H <- histo.from.roi (patient$rtdose[[1]], patient$rtstruct[[1]], 
                     roi.name = "gizzard", 
                     breaks = seq (0, 60, by = 1))
str (H)
}
\seealso{
\link[espadon]{histo.vol}, \link[espadon]{histo.from.bin},
\link[espadon]{display.histo}, \link[espadon]{display.dV_dx}
}
