% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vol_regrid.R
\name{vol.regrid}
\alias{vol.regrid}
\title{Transform the grid of a volume class object into the grid of another}
\usage{
vol.regrid(
  vol,
  back.vol,
  T.MAT = NULL,
  interpolate = TRUE,
  alias = "",
  description = NULL,
  verbose = TRUE
)
}
\arguments{
\item{vol}{"volume" class object to regrid.}

\item{back.vol}{"volume" class object whose grid will be used for regriding.
Its \code{$ref.pseudo} must exist in the \code{T.MAT} list.}

\item{T.MAT}{"t.mat" class object, created by
\link[espadon]{load.patient.from.dicom}, \link[espadon]{load.patient.from.Rdcm},
\link[espadon]{load.T.MAT} or \link[espadon]{ref.add}. If \code{T.MAT = NULL},
\code{back.vol$ref.pseudo} must be equal to \code{vol$ref.pseudo}.}

\item{interpolate}{Boolean, default to \code{TRUE}. If \code{interpolate = TRUE}, a
trilinear interpolation of the value of the voxels, relative to the values of
adjacent voxels, is performed.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the the created object.
If \code{description = NULL}, it will be that of \code{vol}.}

\item{verbose}{Boolean. if \code{TRUE} (default) a progress bar is displayed.}
}
\value{
Returns a copy of \code{vol}, in which grid is that of \code{back.vol}.
}
\description{
The \code{vol.regrid} function transforms the grid of a volume
according to the grid of another.
}
\examples{
# loading of toy-patient objects (decrease dxyz and increase beam.nb for 
# better result)
step <- 5
patient <- toy.load.patient (modality = c ("mr", "rtdose"), 
                             dxyz = rep (step, 3), beam.nb = 4)
MR <- patient$mr[[1]]
D <- patient$rtdose[[1]]

# change grid
D.on.MR <- vol.regrid (vol = D, back.vol = MR, interpolate = TRUE,
                       T.MAT = patient$T.MAT, alias = "",
                       description = NULL, verbose = FALSE)

# maximum dose location
max.dose.in.MR <- get.xyz.from.index (which.max (D.on.MR$vol3D.data), D.on.MR)
display.plane (bottom = MR, view.coord = max.dose.in.MR[3],
               top= D.on.MR, bottom.col = grey.colors(255, start = 0, end = 1),
               bottom.breaks = seq (0, 500, length.out = 256),
               bg = "#00ff00", interpolate = FALSE)
}
