% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pal_rainbow.R
\name{pal.rainbow}
\alias{pal.rainbow}
\title{Rainbow palette}
\usage{
pal.rainbow(n, alpha = seq(0.8, 0, length.out = n))
}
\arguments{
\item{n}{Integer, number of colors to be in the palette}

\item{alpha}{Vector representing the opacity, in the range of 0 (transparent)
to 1 (opaque). If \code{alpha = NULL}, all colors are opaque.}
}
\value{
Returns a color-labeled vector of size \code{n}.
}
\description{
The \code{pal.rainbow} function produces a color palette adapted
to dose repesentation.
}
\examples{
pal <- pal.rainbow (255)

image (x = seq (0, 70, length.out = 255), y = 1,
       z = matrix (seq (0, 70, length.out = 255), ncol = 1),
       col = pal,
       main = "Rainbow colors")
}
