% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_plane.R
\name{get.plane}
\alias{get.plane}
\title{Extracting a plane from a volume}
\usage{
get.plane(
  vol,
  origin = c(0, 0, 0),
  plane.orientation = c(1, 0, 0, 0, 1, 0),
  alias = "plane.n",
  xgrid = NULL,
  ygrid = NULL,
  interpolate = TRUE
)
}
\arguments{
\item{vol}{"volume" class object.}

\item{origin}{Vector of x, y, z coordinates, representing the origin of the
plane to extract. If \code{interpolate = FALSE}, these coordinates are replaced
by the coordinates of the voxel closest to \code{origin}.}

\item{plane.orientation}{Vector orientation of the plane in the \code{vol}
frame of reference, composed by the 2 vectors coordinates of the orthonormal
basis of the plane. First vector is x-axis, and second one is y-axis.}

\item{alias}{\code{$object.alias} of the created object.}

\item{xgrid}{Vector, representing the grid of the plane abscissa. See note.}

\item{ygrid}{Vector, representing the grid of the plane ordinates. See note.
If \code{ygrid = NULL}, the ordinate is the line intercepting the volume and the
step is set to the projection of \code{vol$dxyz} onto the ordinate orientation.}

\item{interpolate}{Boolean, default to \code{TRUE}. If \code{interpolate = TRUE}, a
trilinear interpolation of the value of the voxels, relative to the values of
adjacent voxels, is performed.}
}
\value{
Returns a "volume" class object, containing only a single plane,
at \code{k = 0}, in the same frame of reference as \code{vol}.
This returned object has 2 new fields \code{local.xgrid}, and \code{local.ygrid},
representing the local grids of the abscissa (columns) and ordinate (rows)
of the plane.
}
\description{
The \code{get.plane} function extracts a plane from a "volume"
class object.
}
\note{
\emph{Determination of axes} :
\itemize{
\item the x-axis has \code{plane.orientation[1:3]} as unit vector.
\item the y-axis has \code{plane.orientation[4:6]} as unit vector.
\item If \code{xgrid} is not {NULL}, \code{origin + x.grid * plane.orientation[1:3]}
are the coordinates of the points on the x axis.
\item If \code{ygrid} is not {NULL}, \code{origin + y.grid * plane.orientation[4:6]}
are the coordinates of the points on the y axis.
\item If \code{xgrid} or \code{ygrid} are NULL, they are determined to represent
as closely as possible the initial volume in the required cut.
}
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 4
patient <- toy.load.patient (modality = "mr", dxyz = rep (step, 3))
MR <- patient$mr[[1]] 
    
# mid-volume point 
mid.point <- apply (get.extreme.pt (MR),1,mean)

plane <- get.plane (MR, origin = mid.point, interpolate = TRUE)
display.kplane (plane, interpolate = FALSE)

plane <- get.plane (MR, origin = mid.point, xgrid = seq (-50, 50, 1), 
                    ygrid = seq (-50, 50, 1), interpolate = TRUE)
display.kplane (plane, interpolate = FALSE)

# 3 points on the inclined plane
pts <- t ((MR$xyz.from.ijk \%*\% MR$cube.idx) [1:3 , c (1, 2, 7)])
orientation <- orientation.create (A = pts[1,], B = pts[2,], C = pts[3,])
origin <- apply (pts, 2, mean)
plane <- get.plane (MR, origin = origin, 
                    plane.orientation = orientation, interpolate = TRUE)
display.kplane (plane, interpolate = FALSE)

orientation <- orientation.create (A = c (0, 0, 0) , B = c (1, 1, 0), 
                                   C = c (-1, 1, 0))
plane <- get.plane (MR, origin = origin, 
                    plane.orientation = orientation, interpolate = TRUE) 
display.kplane (plane, interpolate = FALSE)
}
