% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dicom_raw_data_anonymizer.R
\name{dicom.raw.data.anonymizer}
\alias{dicom.raw.data.anonymizer}
\title{DICOM anonymizer}
\usage{
dicom.raw.data.anonymizer(
  dicom.raw.data,
  offset = 0,
  new.PIN = "Anonymous ",
  reset.private.tag = FALSE,
  tag.dictionary = dicom.tag.dictionary()
)
}
\arguments{
\item{dicom.raw.data}{Raw vector, representing the binary extraction of the
DICOM file.}

\item{offset}{Integer, default to 0. Each date of the DICOM will be shifted
by this offset expressed in days.}

\item{new.PIN}{Character string, representing the PIN remplacing the old one.}

\item{reset.private.tag}{Boolean, if \code{TRUE}, the value of tags that are
not in the \code{tag.dictionary} is removed.}

\item{tag.dictionary}{Dataframe, by default equal to
\link[espadon]{dicom.tag.dictionary}, whose structure it must keep. This
dataframe is used to parse DICOM files.}
}
\value{
Returns an anonymyzed raw vector. See Note.
}
\description{
the \code{dicom.raw.data.anonymizer} function anonymizes
\code{dicom.raw.data}.
}
\note{
The raw data is anonymized as follows:
\itemize{
\item Each date of the DICOM file will be shifted by \code{offset} expressed in days.
\item Each patient's name, and patient'ID are remplaced by \code{new.PIN}
\item All other patient data are deleted, except age, weight, height, gender
and shifted birthday.
\item All address, phone, physician, operator, author, reviewer, service.
\item If \code{reset.private.tag = TRUE}, the values of the tags not contained in the \code{tag.dictionary} are
deleted.
}
}
\examples{
# pseudomization of the dummy raw data toy.dicom.raw ()
an.raw.data <- dicom.raw.data.anonymizer (toy.dicom.raw (), offset = -2)
data <- dicom.parser (toy.dicom.raw ())
an.data <- dicom.parser (an.raw.data) 
# Checking for differences
flag.dif <- data$Value !=  an.data$Value  
df <- cbind (data[flag.dif, c ("VM","Value")], an.data[flag.dif, "Value"])      
colnames (df) <-   c ("VM","old Value","new Value")    
df                                     
}
