% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_sonifysignal.R
\name{aux_sonifysignal}
\alias{aux_sonifysignal}
\title{Convert seismic signal to sound (sonification)}
\usage{
aux_sonifysignal(
  data,
  file,
  aggregate = 1,
  amplification = 10^6,
  speed = 1,
  dt
)
}
\arguments{
\item{data}{\code{eseis} object to be converted to sound file}

\item{file}{\code{Character} value, file name under which the sonified 
signal is saved.}

\item{aggregate}{\code{Numeric} value, factor by which the seismic 
file is aggregated before conversion. Aggregation is performed by 
linear interpolation.}

\item{amplification}{\code{Numeric} value, amplification factor. Default 
is \code{10^6}.}

\item{speed}{\code{Numeric} value, factor by which sampling rate is 
increased to make sound sensible. The higher the speed value, the 
higher is the tone. Default is \code{1} (100 Hz seismic signal becomes 
100 Hz sound signal).}

\item{dt}{\code{Numeric} value, samplig rate. Only needed if data is 
not an \code{eseis} object.}
}
\value{
Sound file in wav format, written to disk.
}
\description{
The function converts a seismic signal to sound and saves it as a 
wav file.
}
\examples{

\dontrun{

## load example data
data(rockfall)

## deconvolve and taper signal
s <- signal_deconvolve(data = rockfall_eseis)
s <- signal_taper(data = s, p = 0.05)

## sonify as is (barely sensible, due to too low frequency)
aux_sonifysignal(data = s, 
                 file = "~/Downloads/r1.wav")

## sonify at 20-fold speed
aux_sonifysignal(data = s, 
                 file = "~/Downloads/r1.wav", 
                 speed = 20)
}

}
\author{
Michael Dietze
}
\keyword{eseis}
