% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{hamming-ergmTerm}
\alias{hamming-ergmTerm}
\alias{InitErgmTerm.hamming}
\title{Hamming distance}
\usage{
# binary: hamming(x, cov, attrname=NULL)
}
\arguments{
\item{x}{defaults to be the observed
network, i.e., the network on the left side of the \eqn{\sim} in the formula
that defines the ERGM.}

\item{cov}{either a matrix of edgewise weights or a network}

\item{attrname}{option argument that provides the name of the edge attribute
to use for weight values when a network is specified in \code{cov}}
}
\description{
This term adds one statistic to the model equal to the weighted or
unweighted Hamming distance of the network from the network specified by
\code{x} . Unweighted Hamming distance is defined as the total
number of pairs \eqn{(i,j)} (ordered or unordered, depending on whether the
network is directed or undirected) on which the two networks differ. If the
optional argument \code{cov} is specified, then the weighted Hamming
distance is computed instead, where each pair \eqn{(i,j)} contributes a
pre-specified weight toward the distance when the two networks differ on
that pair.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.
}
\concept{directed}
\concept{dyad-independent}
\concept{undirected}
