% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm-terms-index.R
\name{search.ergmTerms}
\alias{search.ergmTerms}
\title{Search the ERGM terms}
\usage{
search.ergmTerms(search, net, keywords, name, packages)
}
\arguments{
\item{search}{optional character search term to search for in the text of the
term descriptions. Only matching terms will be returned. Matching is case
insensitive.}

\item{net}{a network object that the term would be applied to, used as
template to determine directedness, bipartite, etc}

\item{keywords}{optional character vector of keyword tags to use to
restrict the results (i.e. 'curved', 'triad-related')}

\item{name}{optional character name of a specific term to return}

\item{packages}{optional character vector indicating the subset of packages in which to search}
}
\value{
prints out the name and short description of matching terms, and
invisibly returns them as a list.  If \code{name} is specified, prints out
the full definition for the named term.
}
\description{
Searches through the \code{\link{ergm.terms}} help page and prints out a
list of terms appropriate for the specified network's structural
constraints, optionally restricting by additional keywords and search term
matches.
}
\details{
Uses \code{\link{grep}} internally to match the search terms against the term
description, so \code{search} is currently matched as a single phrase.
Keyword tags will only return a match if all of the specified tags are
included in the term.
}
\examples{
\donttest{
# find all of the terms that mention triangles
search.ergmTerms('triangle')

# two ways to search for bipartite terms:

# search using a bipartite net as a template
myNet<-network.initialize(5,bipartite=3)
search.ergmTerms(net=myNet)

# or request the bipartite keyword
search.ergmTerms(keywords='bipartite')

# search on multiple keywords
search.ergmTerms(keywords=c('bipartite','dyad-independent'))

# print out the content for a specific term
search.ergmTerms(name='b2factor')

# request the bipartite keyword in the ergm package
search.ergmTerms(keywords='bipartite', packages='ergm')
}
}
\seealso{
See also \code{\link{ergm.terms}} for the complete documentation
}
\author{
skyebend@uw.edu
}
