% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm.Cprepare.R, R/ergm.design.R
\name{ergm_Clist}
\alias{ergm_Clist}
\alias{ergm.Cprepare}
\alias{ergm_Clist.network}
\alias{ergm_Clist.ergm_model}
\alias{ergm.design}
\title{Internal Functions to Prepare Data for ergm's C Interface}
\usage{
ergm_Clist(object, ...)

ergm.Cprepare(nw, m, response = NULL)

\method{ergm_Clist}{network}(object, response = NULL, ...)

\method{ergm_Clist}{ergm_model}(object, ...)

ergm.design(nw, verbose = FALSE)
}
\arguments{
\item{object}{object to be collated.}

\item{...}{additional arguments for methods.}

\item{nw}{a network or similar object}

\item{m}{a model object, as returned by \code{\link{ergm_model}}}

\item{response}{Name of the edge attribute whose value is to be
modeled in the valued ERGM framework. Defaults to \code{NULL} for
simple presence or absence, modeled via a binary ERGM.}

\item{verbose}{logical, whether the design matrix should be printed;
default=FALSE}
}
\value{
A list of class \code{"ergm_Clist"} and possibly a subclass \code{"ORIGINAL.ergm_Clist"} containing some subset of the following elements:

\item{n}{ the size of the network }
\item{dir}{ whether the network is directed (T or F) }
\item{bipartite}{ whether the network is bipartite (T or F) }
\item{ndyads}{ the number of dyads in the network }
\item{nedges}{ the number of edges in this network }
\item{tails}{ the vector of tail nodes; tail nodes are the 1st
column of the implicit edgelist, so either the lower-numbered nodes in an
undirected graph, or the out nodes of a directed graph, or the b1 nodes of a
bipartite graph }
\item{heads}{ the vector of head nodes; head nodes are the
2nd column of the implicit edgelist, so either the higher-numbered nodes in
an undirected graph, or the in nodes of a directed graph, or the b2 nodes of
a bipartite graph }

\item{nterms}{ the number of model terms }
\item{nstats}{ the total number of change statistics for all model terms }
\item{inputs}{ the concatenated vector of 'input's from each model term as returned by
\code{InitErgmTerm.X} or \code{InitErgm.X} }
\item{fnamestring}{ the concatenated string of model term names }
\item{snamestring}{ the concatenated string of package names that contain the C function 'd_fname'; default="ergm" for each fname in fnamestring }

\code{ergm.design} returns a \code{\link{rlebdm}} of
informative (non-missing, non fixed) dyads.
}
\description{
These are internal functions not intended to be called by end
users. \code{ergm_Clist} collates the information in the given object
into a form suitable for being passed to the C routines.

The \code{ergm.Cprepare} is a legacy function that constructs a combination of \code{ergm_Clist}s from the given \code{\link{network}} and the given \code{\link{ergm_model}}.

\code{ergm.design} obtain the set of informative dyads based on the network structure. Note that \code{model=} argument is not needed and will be removed in a future release.
}
\section{Methods (by class)}{
\itemize{
\item \code{network}: Collates a \code{\link{network}} object.

\item \code{ergm_model}: Collates an \code{\link{ergm_model}} object.
}}

\keyword{internal}
