% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EgoStat.node.attr.R
\name{node-attr-api}
\alias{node-attr-api}
\alias{ergm.ego_get_vattr}
\alias{ergm.ego_get_vattr.character}
\alias{ergm.ego_get_vattr.function}
\alias{ergm.ego_get_vattr.formula}
\alias{ergm.ego_attr_levels}
\alias{ergm.ego_attr_levels.numeric}
\alias{ergm.ego_attr_levels.logical}
\alias{ergm.ego_attr_levels.AsIs}
\alias{ergm.ego_attr_levels.character}
\alias{ergm.ego_attr_levels.NULL}
\alias{ergm.ego_attr_levels.function}
\alias{ergm.ego_attr_levels.formula}
\title{Helper functions for specifying nodal attribute levels}
\usage{
ergm.ego_get_vattr(object, df, accept = "character", ...)

\method{ergm.ego_get_vattr}{character}(object, df, accept = "character",
  ...)

\method{ergm.ego_get_vattr}{function}(object, df, accept = "character",
  ...)

\method{ergm.ego_get_vattr}{formula}(object, df, accept = "character",
  ...)

ergm.ego_attr_levels(object, attr, egodata, levels = sort(unique(attr)),
  ...)

\method{ergm.ego_attr_levels}{numeric}(object, attr, egodata,
  levels = sort(unique(attr)), ...)

\method{ergm.ego_attr_levels}{logical}(object, attr, egodata,
  levels = sort(unique(attr)), ...)

\method{ergm.ego_attr_levels}{AsIs}(object, attr, egodata,
  levels = sort(unique(attr)), ...)

\method{ergm.ego_attr_levels}{character}(object, attr, egodata,
  levels = sort(unique(attr)), ...)

\method{ergm.ego_attr_levels}{NULL}(object, attr, egodata,
  levels = sort(unique(attr)), ...)

\method{ergm.ego_attr_levels}{function}(object, attr, egodata,
  levels = sort(unique(attr)), ...)

\method{ergm.ego_attr_levels}{formula}(object, attr, egodata,
  levels = sort(unique(attr)), ...)
}
\arguments{
\item{object}{An argument specifying the nodal attribute to select
or which levels to include.}

\item{df}{Table of egos or of alters.}

\item{accept}{A character vector listing permitted data types for
the output. See the Details section for the specification.}

\item{...}{Additional argument to the functions of network or to
the formula's environment.}

\item{attr}{A vector of length equal to the number of nodes,
specifying the attribute vector.}

\item{egodata}{An \code{\link{egodata}} object.}

\item{levels}{Starting set of levels to use; defaults to the sorted
list of unique attributes.}
}
\value{
\code{ergm.ego_get_vattr} returns a vector of length equal to the number of nodes giving the
selected attribute function. It may also have an attribute
\code{"name"}, which controls the suggested name of the attribute
combination.

\code{ergm.ego_attr_levels} returns a vector of levels to use and their order.
}
\description{
These functions are meant to be used in \code{EgoStat} and
other implementations to provide the user with a way to extract
nodal attributes and select their levels in standardized and
flexible ways described under \code{\link{node-attr}}. They are intended to
parallel \link{node-attr-api} of \code{ergm} package.

\code{ergm.ego_get_vattr} extracts and processes the specified
nodal attribute vector. It is strongly recommended that
\code{\link[=check.ErgmTerm]{check.ErgmTerm()}}'s corresponding
\code{vartype="function,formula,character"} (using the
\code{ERGM_VATTR_SPEC} constant).

\code{ergm.ego_attr_levels} filters the levels of the
attribute.  It is strongly recommended that \code{\link[=check.ErgmTerm]{check.ErgmTerm()}}'s
corresponding
\code{vartype="function,formula,character,numeric,logical,AsIs,NULL"} (using the
\code{ERGM_LEVELS_SPEC} constant).
}
\details{
The \code{accept} argument is meant to allow the user to
quickly check whether the output is of an \emph{acceptable} class or
mode. Typically, if a term accepts a character (i.e.,
categorical) attribute, it will also accept a numeric one,
treating each number as a category label. For this reason, the
following outputs are defined:
\describe{

\item{\code{"character"}}{Accept any mode or class (since it can
beconverted to character).}

\item{\code{"numeric"}}{Accept real, integer, or logical.}

\item{\code{"logical"}}{Accept logical.}

\item{\code{"integer"}}{Accept integer or logical.}

\item{\code{"natural"}}{Accept a strictly positive integer.}

\item{\code{"0natural"}}{Accept a nonnegative integer or logical.}

\item{\code{"nonnegative"}}{Accept a nonnegative number or logical.}

\item{\code{"positive"}}{Accept a strictly positive number or logical.}
}
}
\examples{
data(florentine)
flomego <- as.egodata(flomarriage)
ergm.ego_get_vattr("priorates", flomego$egos)
ergm.ego_get_vattr(~priorates, flomego$alters)
ergm.ego_get_vattr(c("wealth","priorates"), flomego$egos)
ergm.ego_get_vattr(~priorates>30, flomego$alters)
(a <- ergm.ego_get_vattr(~cut(priorates,c(-Inf,0,20,40,60,Inf),label=FALSE)-1, flomego$egos))
ergm.ego_attr_levels(NULL, a, flomego$egos)
ergm.ego_attr_levels(-1, a, flomego$egos)
ergm.ego_attr_levels(1:2, a, flomego$egos)
ergm.ego_attr_levels(I(1:2), a, flomego$egos)
}
