% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.R
\name{createPhenoTable}
\alias{createPhenoTable}
\title{Create Phenotype Table}
\usage{
createPhenoTable(files, cls)
}
\arguments{
\item{files}{File paths to experiment samples.}

\item{cls}{Character vector containing sample classes.}
}
\description{
Create table containing sample meta information such as as sample ID and class.
}
\details{
Creates phenotype information table based on experiment sample file paths and sample classes. Columns containing further information can also be added to this.
}
\examples{
library(gcspikelite)
data(targets)

files <- list.files(system.file('data',package = 'gcspikelite'),full.names = TRUE)
files <- files[sapply(files,grepl,pattern = 'CDF')]

phenotype <- createPhenoTable(files,as.character(targets$Group[order(targets$FileName)]))
}
\seealso{
\code{\link{newExp}} \code{\link{createInstrumentalTable}}
}
