#' Test Scores under a NEAT design
#' 
#' This dataset contains scores for two forms of a 36-item test administered
#' under a nonequivalent groups with anchor test design. The anchor test is
#' internal and consists of twelve items taken by both groups of examinees. The
#' data is distributed as part of the equating software CIPE (see link below),
#' and additional examples using this dataset are presented in \emph{Test
#' Equating, Scaling, and Linking} (Kolen and Brennan, 2004).
#' 
#' @name KBneat
#' @docType data
#' @format A list of length two, where each element (\code{$x} and \code{$y})
#' contains two columns of data, one for the total score and another for the
#' anchor test score for each examinee.
#' @source Kolen, M. J., & Brennan, R. L. (2004). \emph{Test Equating, Scaling,
#' and Linking}. (2nd ed.), New York: Springer.
#' 
#' The dataset can be downloaded as part of the CIPE software, available at the
#' following link:
#' \url{https://education.uiowa.edu/casma}
#' @keywords datasets
"KBneat"