% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiArmAnalysis.R
\name{multiArmAnalysis}
\alias{multiArmAnalysis}
\title{Bayesian or Frequentist Analysis with Forest Plot Comparison for Multi-Arm Trial Designs}
\usage{
multiArmAnalysis(
  method = "crtBayes",
  data,
  outcome = "posttest",
  interventions = "interventions",
  Random = "schools",
  Nsim = 10000,
  Threshold = 0.05,
  FREQoption = "Default",
  nPerm = NULL,
  nBoot = NULL,
  bootType = NULL,
  continuous_covariates = NULL,
  categorical_covariates = NULL,
  maintitle = NULL,
  xlabel = NULL,
  ylabel = NULL,
  vlinecolor = "black",
  intlabels = NULL,
  intcolors = NULL
)
}
\arguments{
\item{method}{The model fitting method. Should be specified as a character string. Choices are:
\itemize{
\item \code{"crtBayes"}: Bayesian analysis of cluster randomised trials using vague priors.
\item \code{"crtFREQ"}: Analysis of cluster randomised trials using a multilevel model under a frequentist setting.
\item \code{"mstBayes"}: Bayesian analysis of multisite randomised trials using vague priors.
\item \code{"mstFREQ"}: Analysis of multisite randomised trials using a multilevel model under a frequentist setting.
\item \code{"srtBayes"}: Bayesian analysis of simple randomised trials using vague priors.
\item \code{"srtFREQ"}: Analysis of simple randomised trials under a frequentist setting.
}}

\item{data}{A data frame containing the variables including outcome, predictors, the clustering variable, and the intervention.}

\item{outcome}{The name of the outcome (post-test) variable.}

\item{interventions}{A string specifying the intervention variable.}

\item{Random}{The name of the clustering variable (e.g., schools or sites) for CRT and MST designs.}

\item{Nsim}{Number of MCMC iterations to be performed for Bayesian analysis. A minimum of 10,000 is recommended to ensure convergence.}

\item{Threshold}{The effect size threshold for posterior computation for Bayesian analysis (default = 0.05).}

\item{FREQoption}{The option for frequentist methods. Choices are "Default", "Permutation", or "Bootstrap".}

\item{nPerm}{The number of permutations required to generate a permutated p-value.}

\item{nBoot}{The number of bootstraps required to generate bootstrap confidence intervals.}

\item{bootType}{method of bootstrapping including case re-sampling at student level "case(1)",case re-sampling at school level "case(2)", case re-sampling at both levels "case(1,2)" and residual bootstrapping using "residual". If not provided, default will be case re-sampling at student level.}

\item{continuous_covariates}{A character vector specifying the names of continuous covariates.}

\item{categorical_covariates}{A character vector specifying the names of categorical covariates (converted to factors).}

\item{maintitle}{main title for the plot.}

\item{xlabel}{Label for the x-axis.}

\item{ylabel}{Label for the y-axis.}

\item{vlinecolor}{Color of the vertical reference line (default = "black").}

\item{intlabels}{Optional custom intervention labels for the plot.}

\item{intcolors}{Optional intervention colors for the plot.}
}
\value{
A \code{ggplot} object showing intervention effect sizes and their confidence intervals.
}
\description{
This function fits Bayesian or frequentist and producing a forest plot across multiple
intervention groups for cluster randomized trials (CRT), multisite trials (MST) or simple randomized trials (SRT).
}
\details{
This function loops through each intervention, fits the requested statistical model,
stores the results, and forest plot visualization for easy comparison. It allows flexible customization for plotting aesthetics.
}
\examples{
\donttest{
### Bayesian analysis of cluster randomised trials ###
data(crt4armSimData)
multiArmAnalysis(method = "crtBayes", data = crt4armSimData, outcome = "posttest", 
interventions = "interventions", Random = "schools", Nsim = 10000, Threshold = 0.05, 
continuous_covariates = c("pretest"), categorical_covariates = c("gender", "ethnicity"),
intlabels = c("Intervention A", "Intervention B", "Intervention C"),
maintitle = "Forest plot of comparison of effect sizes", xlabel = "Hedges'g", 
ylabel = "Interventions", vlinecolor = "black")

###MLM analysis of multisite trials with residual bootstrap confidence intervals ###
data(mst4armSimData)
multiArmAnalysis(method = "mstFREQ", data = mst4armSimData, outcome = "posttest",
interventions = "interventions", Random = "schools", nBoot = 1000, bootType="residual",
continuous_covariates = c("pretest"), categorical_covariates = c("gender", "ethnicity"),
intlabels = c("Intervention A", "Intervention B", "Intervention C"),
intcolors = c("Intervention A" = "blue", "Intervention B" = "green", "Intervention C" = "red"),
maintitle = "Forest plot of comparison of effect sizes ", xlabel = "Hedges'g",
ylabel = "Interventions", vlinecolor = "black")

###MLM analysis of multisite trials with permutation p-value###
data(mst4armSimData)
multiArmAnalysis(method = "mstFREQ", data = mst4armSimData, outcome = "posttest", 
interventions = "interventions", Random = "schools", nPerm = 1000, 
continuous_covariates = c("pretest"), categorical_covariates = c("gender", "ethnicity"), 
intlabels = c("Intervention A", "Intervention B", "Intervention C"),
intcolors = c("Intervention A" = "blue", "Intervention B" = "green", "Intervention C" = "red"), 
maintitle = "Forest plot of comparison of effect sizes ",
xlabel = "Hedges'g", ylabel = "Interventions", vlinecolor = "black")


###Bayesian analysis of simple randomised trials###
data(srt4armSimData)
multiArmAnalysis(method = "srtBayes", data = srt4armSimData, outcome = "posttest",
interventions = "interventions", Random = "schools", Nsim = 10000, Threshold = 0.05, 
continuous_covariates = c("pretest"), categorical_covariates = c("gender", "ethnicity"),
intlabels = c("Int A", "Int B", "Int C"),
intcolors = c("Int A" = "#1F77B4", "Int B" = "#2CA02C", "Int C" = "#D62728"),
maintitle = "Forest plot of comparison of effect sizes ", xlabel = "Hedges'g", 
ylabel = "Interventions", vlinecolor = "black")
}

}
\seealso{
Functions from the \pkg{eefAnalytics} package:
\code{\link[eefAnalytics]{crtBayes}}, \code{\link[eefAnalytics]{crtFREQ}}, \code{\link[eefAnalytics]{mstBayes}}, \code{\link[eefAnalytics]{mstFREQ}}, \code{\link[eefAnalytics]{srtBayes}}, \code{\link[eefAnalytics]{srtFREQ}}
}
