% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{custom_validate}
\alias{custom_validate}
\title{Customize validation components}
\usage{
custom_validate(
  required_object = FALSE,
  unique_object = FALSE,
  unique_name = FALSE,
  extensible = FALSE,
  required_field = FALSE,
  auto_field = FALSE,
  type = FALSE,
  choice = FALSE,
  range = FALSE,
  reference = FALSE
)
}
\arguments{
\item{required_object}{Check if required objects are missing in current
model. Default: \code{FALSE}.}

\item{unique_object}{Check if there are multiple objects in one unique-object
class. Default: \code{FALSE}.}

\item{unique_name}{Check if all objects in every class have unique names.
Default: \code{FALSE}.}

\item{extensible}{Check if all fields in an extensible group have values.
Default: \code{FALSE}.}

\item{required_field}{Check if all required fields have values. Default:
\code{FALSE}.}

\item{auto_field}{Check if all fields with value \code{"Autosize"} and
\code{"Autocalculate"} are valid or not. Default: \code{FALSE}.}

\item{type}{Check if all fields have values with valid types, i.e.
character, numeric and integer fields should be filled with corresponding
type of values. Default: \code{FALSE}.}

\item{choice}{Check if all choice fields have valid choice values. Default:
\code{FALSE}.}

\item{range}{Check if all numeric fields have values within defined ranges.
Default: \code{FALSE}.}

\item{reference}{Check if all fields whose values refer to other fields are
valid. Default: \code{FALSE}.}
}
\value{
A named list with 10 elements.
}
\description{
\code{custom_validate()} makes it easy to customize what validation components
should be included during IDF object modifications using \verb{$dup()}, \verb{$add()},
\verb{$set()} and other methods in \link{Idf} class.
}
\details{
There are 10 different validation check components in total. Three predefined
validation level are included, i.e. \code{"none"}, \code{"draft"} and \code{"final"}. To get
what validation components those levels contain, see \code{\link[=level_checks]{level_checks()}}.
}
\examples{
custom_validate(unique_object = TRUE)

# only check unique name during validation
eplusr_option(validate_level = custom_validate(unique_name = TRUE))
}
