% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{save_config}
\alias{save_config}
\title{Save the configuration changes}
\usage{
save_config(data_dir = conf$data_dir, properties = TRUE, topics = TRUE)
}
\arguments{
\item{data_dir}{Path to a directory to save configuration settings, Default: conf$data_dir}

\item{properties}{Whether to save the general properties to the properties.json file, default: TRUE}

\item{topics}{Whether to save topic download plans to the topics.json file, default: TRUE}
}
\value{
Nothing
}
\description{
Permanently saves configuration changes to the data folder (excluding Twitter credentials, but not SMTP credentials)
}
\details{
Permanently saves configuration changes to the data folder (excluding Twitter credentials, but not SMTP credentials)
to save Twitter credentials please use \code{\link{set_twitter_app_auth}}
}
\examples{
if(FALSE){
   library(epitweetr)
   #load configuration
   message('Please choose the epitweetr data directory')
   setup_config(file.choose())
   #make some changes
   #conf$collect_span = 90
   #saving changes    
   save_config()
}
}
\seealso{
\code{\link{setup_config}}
\code{\link{set_twitter_app_auth}}
}
