% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash_names.R
\name{hash_names}
\alias{hash_names}
\title{Anonymise data using SHA1}
\usage{
hash_names(..., size = 6, full = TRUE, salt = NULL)
}
\arguments{
\item{...}{Data fields to be hashed.}

\item{size}{The number of characters retained in the hash.}

\item{full}{A logical indicating if the a full output should be returned as a
\code{data.frame}, including original labels, shortened hash, and full
hash.}

\item{salt}{An optional object to be used to 'salt' the hashing algorithm
(see details). Ignored if \code{NULL} (default).}
}
\description{
This function uses SHA1 algorithm to anonymise data, based on user-indicated
data fields. Data fields are concatenated first, then each entry is
hashed. The function can either return a full detailed output, or short
labels ready to use for 'anonymised data'. \cr
}
\details{
Before concatenation (using "_" as a separator) to form labels, inputs are
modified as follows:

\itemize{

\item all spaces and non-alphanumeric characters are removed

\item all diacritics are replaced with their non-accentuated equivalents,
e.g. 'é', 'ê' and 'è' become 'e', 'ö' becomes 'o', etc.

\item all non-ascii characters are removed

\item all characters are set to lower case

}

The argument \code{salt} can be used for salting the algorithm, i.e. adding
an extra input to the input fields (the 'salt') to change the resulting hash
and prevent identification of individuals via pre-computed hash
tables. Objects provided as \code{salt} will themselves be hashed using SHA1
algorithm, and the full hash is appended to the labels.
}
\examples{

first_name <- c("Jane", "Joe", "Raoul")
last_name <- c("Doe", "Smith", "Dupont")
age <- c(25, 69, 36)

hash_names(first_name, last_name, age)

hash_names(first_name, last_name, age,
           size = 8, full = FALSE)


## salting the hashing (more secure!)
hash_names(first_name, last_name) # unsalted - less secure
hash_names(first_name, last_name, salt = 123) # salted with an integer
hash_names(first_name, last_name, salt = "foobar") # salted with an character
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
