% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ode.R
\name{rlk}
\alias{rlk}
\title{Create 'rlk' (Rational Law Kinetics) object}
\usage{
rlk(A, B, s = solver(), r = NULL, rx0 = reg("none", lower = 0, upper =
  Inf, fixed = TRUE))
}
\arguments{
\item{A}{The matrix of powers (pxd). Here d the number of species.}

\item{B}{The matrix of powers (pxd). Here d the number of species.}

\item{s}{\code{\link{solver}} object.}

\item{r}{An object of class \code{\link{reg}} giving info about how to regularise and bound the rate parameters. If not provided, the default one is used.}

\item{rx0}{An object of class \code{\link{reg}} giving info about how to regularise and bound the initial state parameter. If not provided, the default one is used. This default \code{reg} sets \code{fixed = TRUE}, which is generally recommended.}
}
\value{
An object with S3 class "rlk" and "ode".
}
\description{
This function creates an object of class \code{rlk} (subclass of \code{ode}), which holds the basic information of the Rational Law Kinetics system in question.
}
\details{
Rational Law Kinetics is a class of ODE systems, having the following vector field:
\deqn{\frac{dx}{dt} = \theta (x^A / (1 + x^B))}
with \eqn{x^A = (\prod_{i=1}^dx_i^{A_{ji}})_{j=1}^p} and \eqn{\theta} an estimatable parameter matrix of dimension dxp. By convention theta will only be reported as a vector (concatinated column-wise).
}
\examples{
# Rational law kinetics
A <- matrix(
c(1, 0, 0, 0,
  0, 1, 2, 0,
  0, 0, 0, 1), ncol = 4, byrow = TRUE)
theta <- matrix(
c(0, 2, -0.5, 0,
  1, 0, 0, 1,
  -1, -1, -1, -1), ncol = 3, byrow = TRUE)
x0 <- c(X = 1, Y = 4, Z = 0.1, W = 0.1)
time <- seq(0, 1, by = .1)
r <- rlk(A, A[c(2, 1, 3), ])

# Solve system
numsolve(o = r, time = time, x0 = x0, param = theta)

# Evaluate field
field(r, x0, theta)

}
\seealso{
ode, numsolve, field
}
