% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intensity-classes.R
\name{clump}
\alias{clump}
\alias{clump.intensity}
\title{Regroup observational data into even clumps of individuals.}
\usage{
clump(object, ...)

\method{clump}{intensity}(object, unit_size, fun = sum,
  inclusive_unspecified = FALSE, ...)
}
\arguments{
\item{object}{An \code{intensity} object.}

\item{...}{Additional arguments to be passed to \code{fun}.}

\item{unit_size}{Size of a group unit. It must be a named vector, with names
corresponding to non-observational variables (i.e. space and time
variables). If the size of a variable in the data set is not a multiple
of the provided value in \code{unit_size}, some sampling units (the last
ones) will be dropped so that clumps of individuals remain even
throughout the data set.}

\item{fun}{Function used to group observational data together.}

\item{inclusive_unspecified}{Not yet implemented. Do unspecified mapped
variables (different from i and n) need to be included into the bigger
possible sampling unit (TRUE) or splited into as many sampling units as
possible (FALSE, default)?}
}
\description{
This function provides a easy way to regroup recorded data into groups of
same number of individuals.
}
\examples{
my_incidence <- incidence(tomato_tswv$field_1929)
plot(my_incidence, type = "all")

# Different spatial size units:
my_incidence_clumped_1 <- clump(my_incidence, unit_size = c(x = 3, y = 3))
plot(my_incidence_clumped_1, type = "all")

my_incidence_clumped_2 <- clump(my_incidence, unit_size = c(x = 4, y = 5))
plot(my_incidence_clumped_2, type = "all")

# To get mean disease incidence for each plant over the 3 scoring dates:
my_incidence_clumped_3 <- clump(my_incidence, unit_size = c(t = 3), fun = mean)
plot(my_incidence_clumped_3)


}
