% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiparameter.R
\name{discretise}
\alias{discretise}
\alias{discretize}
\alias{discretise.epiparameter}
\alias{discretise.default}
\title{Discretises a continuous distribution in an \verb{<epiparameter>} object}
\usage{
discretise(x, ...)

discretize(x, ...)

\method{discretise}{epiparameter}(x, ...)

\method{discretise}{default}(x, ...)
}
\arguments{
\item{x}{An \verb{<epiparameter>} object.}

\item{...}{\link{dots} Extra arguments to be passed to the method.}
}
\value{
An \verb{<epiparameter>} object.
}
\description{
Discretises a continuous distribution in an \verb{<epiparameter>} object
}
\details{
Converts the S3 distribution object in an \verb{<epiparameter>} from
continuous (using an object from the \code{{distributional}} package) to a
discretised distribution (using an object from the \code{{distcrete}} package).
}
\examples{
ebola_incubation <- epiparameter(
  disease = "ebola",
  epi_name = "incubation_period",
  prob_distribution = create_prob_distribution(
    prob_distribution = "gamma",
    prob_distribution_params = c(shape = 1, scale = 1)
  )
)
discretise(ebola_incubation)
}
